/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.validations.TimezoneId;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

@KestraTest
class TimezoneIdTest {
    @Inject
    private ModelValidator modelValidator;

    TimezoneIdTest() {
    }

    @Test
    void inputValidation() {
        TimezoneIdCls existingTimezone = new TimezoneIdCls("Europe/Paris");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)existingTimezone).isEmpty()).isTrue();
        TimezoneIdCls invalidTimezone = new TimezoneIdCls("Foo/Bar");
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)invalidTimezone).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)invalidTimezone).get()).getMessage()).satisfies(new ThrowingConsumer[]{arg -> Assertions.assertThat((String)arg).startsWith((CharSequence)"timezone"), arg -> Assertions.assertThat((String)arg).contains(new CharSequence[]{"is not a valid time-zone ID"})});
    }

    @Introspected
    public static class TimezoneIdCls {
        @TimezoneId
        String timezone;

        @ConstructorProperties(value={"timezone"})
        @Generated
        public TimezoneIdCls(String timezone) {
            this.timezone = timezone;
        }

        @Generated
        public String getTimezone() {
            return this.timezone;
        }
    }
}

