/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.plugin.core.flow.Pause;
import io.kestra.plugin.core.flow.WorkingDirectory;
import io.kestra.plugin.core.log.Log;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class WorkingDirectoryTest {
    @Inject
    private ModelValidator modelValidator;

    @Test
    void workingDirectoryValid() {
        WorkingDirectory workingDirectory = ((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)WorkingDirectory.builder().id("workingDir")).type(WorkingDirectory.class.getName())).tasks(List.of(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id("log")).type(Log.class.getName())).message((Object)"Hello World").build()))).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)workingDirectory).isPresent()).isFalse();
    }

    @Test
    void workingDirectoryInvalid() {
        WorkingDirectory workingDirectory = ((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)WorkingDirectory.builder().id("workingDir")).type(WorkingDirectory.class.getName())).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)workingDirectory).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)workingDirectory).get()).getMessage()).contains(new CharSequence[]{"The 'tasks' property cannot be empty"});
        workingDirectory = ((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)WorkingDirectory.builder().id("workingDir")).type(WorkingDirectory.class.getName())).tasks(List.of(((Pause.PauseBuilder)((Pause.PauseBuilder)Pause.builder().id("pause")).type(Pause.class.getName())).delay(Property.ofValue((Object)Duration.ofSeconds(1L))).build()))).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)workingDirectory).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)workingDirectory).get()).getMessage()).contains(new CharSequence[]{"Only runnable tasks are allowed as children of a WorkingDirectory task"});
        workingDirectory = ((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)((WorkingDirectory.WorkingDirectoryBuilder)WorkingDirectory.builder().id("workingDir")).type(WorkingDirectory.class.getName())).tasks(List.of(((Log.LogBuilder)((Log.LogBuilder)((Log.LogBuilder)Log.builder().id("log")).type(Log.class.getName())).message((Object)"Hello World").workerGroup(new WorkerGroup("toto", null))).build()))).build();
        Assertions.assertThat((boolean)this.modelValidator.isValid((Object)workingDirectory).isPresent()).isTrue();
        Assertions.assertThat((String)((ConstraintViolationException)this.modelValidator.isValid((Object)workingDirectory).get()).getMessage()).contains(new CharSequence[]{"Cannot set a Worker Group in any WorkingDirectory sub-tasks, it is only supported at the WorkingDirectory level"});
    }
}

