/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.extractors;

import io.kestra.core.models.property.Property;
import io.kestra.core.validations.extractors.DynamicPropertyDto;
import io.micronaut.test.extensions.junit5.annotation.MicronautTest;
import io.micronaut.validation.validator.Validator;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolation;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@MicronautTest
public class PropertyValueExtractorTest {
    @Inject
    private Validator validator;

    @Test
    public void should_extract_and_validate_integer_value() {
        DynamicPropertyDto dto = new DynamicPropertyDto((Property<Integer>)Property.ofValue((Object)20), (Property<String>)Property.ofValue((Object)"Test"));
        Set violations = this.validator.validate((Object)dto, new Class[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)violations.isEmpty());
        dto = new DynamicPropertyDto((Property<Integer>)Property.ofValue((Object)5), (Property<String>)Property.ofValue((Object)"Test"));
        violations = this.validator.validate((Object)dto, new Class[0]);
        Assertions.assertThat((int)violations.size()).isEqualTo(1);
        ConstraintViolation violation = (ConstraintViolation)violations.stream().findFirst().get();
        Assertions.assertThat((String)violation.getMessage()).isEqualTo("must be greater than or equal to 10");
    }
}

