/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.DateTimeBetween;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class DateTimeBetweenTest {
    @Inject
    ConditionService conditionService;

    DateTimeBetweenTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{ZonedDateTime.now().toString(), null, ZonedDateTime.parse("2013-09-08T16:19:12.000000+02:00"), true}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2013-09-08T16:19:12.000000+02:00").toString(), null, ZonedDateTime.now(), false}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2013-09-08T16:19:12.000000+02:00").toString(), ZonedDateTime.parse("2013-09-08T16:20:12.000000+02:00"), ZonedDateTime.parse("2013-09-08T16:18:12.000000+02:00"), true}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2013-09-08T16:19:12.000000+02:00").toString(), ZonedDateTime.parse("2013-09-08T16:20:12.000000+02:00"), null, true}), Arguments.of((Object[])new Object[]{"{{ now() }}", ZonedDateTime.now().plusHours(1L), ZonedDateTime.now().plusHours(-1L), true}), Arguments.of((Object[])new Object[]{"{{ now() }}", ZonedDateTime.now().plusHours(-1L), null, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(String date, ZonedDateTime before, ZonedDateTime after, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        DateTimeBetween build = DateTimeBetween.builder().date(date).before(Property.ofValue((Object)before)).after(Property.ofValue((Object)after)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

