/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.DayWeekInMonth;
import jakarta.inject.Inject;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class DayWeekInMonthTest {
    @Inject
    ConditionService conditionService;

    DayWeekInMonthTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-01").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.FIRST, false}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-05").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.FIRST, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-01").toString(), DayOfWeek.THURSDAY, DayWeekInMonth.DayInMonth.FIRST, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-01").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.LAST, false}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-26").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.LAST, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-12").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.SECOND, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-19").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.THIRD, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2021-04-26").toString(), DayOfWeek.MONDAY, DayWeekInMonth.DayInMonth.FOURTH, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(String date, DayOfWeek dayOfWeek, DayWeekInMonth.DayInMonth dayInMonth, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        DayWeekInMonth build = DayWeekInMonth.builder().date(date).dayOfWeek(Property.ofValue((Object)dayOfWeek)).dayInMonth(Property.ofValue((Object)dayInMonth)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

