/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.DayWeek;
import jakarta.inject.Inject;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class DayWeekTest {
    @Inject
    ConditionService conditionService;

    DayWeekTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{LocalDate.parse("2013-09-08").toString(), DayOfWeek.SUNDAY, true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2013-09-08").toString(), DayOfWeek.MONDAY, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(String date, DayOfWeek dayOfWeek, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        DayWeek build = DayWeek.builder().date(Property.ofValue((Object)date)).dayOfWeek(Property.ofValue((Object)dayOfWeek)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

