/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.Label;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionLabels;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
public class ExecutionLabelsTest {
    @Inject
    ConditionService conditionService;

    @Test
    void valid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of()).toBuilder().labels(List.of(new Label("key", "value"))).build();
        ExecutionLabels build = ExecutionLabels.builder().labels(List.of(new Label("key", "value"))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void validMultiples() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of()).toBuilder().labels(List.of(new Label("key", "value"), new Label("key2", "value2"))).build();
        ExecutionLabels build = ExecutionLabels.builder().labels(List.of(new Label("key", "value"), new Label("key2", "value2"))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void invalid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionLabels build = ExecutionLabels.builder().labels(List.of(new Label("key", "value"))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }

    @Test
    void invalidMultiples() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of()).toBuilder().labels(List.of(new Label("key", "value"))).build();
        ExecutionLabels build = ExecutionLabels.builder().labels(List.of(new Label("key", "value"), new Label("key2", "value2"))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }
}

