/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionNamespace;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ExecutionNamespaceTest {
    @Inject
    ConditionService conditionService;

    ExecutionNamespaceTest() {
    }

    @Test
    void valid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace())).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
        build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace())).comparison(Property.ofValue((Object)ExecutionNamespace.Comparison.EQUALS)).build();
        test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void invalid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)(flow.getNamespace() + "a"))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }

    @Test
    void prefix() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = (ExecutionNamespace)JacksonMapper.toMap(Map.of("type", ExecutionNamespace.class.getName(), "namespace", flow.getNamespace().substring(0, 3), "prefix", true), ExecutionNamespace.class);
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
        build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace().substring(0, 3))).comparison(Property.ofValue((Object)ExecutionNamespace.Comparison.PREFIX)).build();
        test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
        build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace().substring(0, 3))).prefix(Property.ofValue((Object)true)).build();
        test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void defaultBehaviour() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace().substring(0, 3))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }

    @Test
    void suffix() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = ExecutionNamespace.builder().namespace(Property.ofValue((Object)flow.getNamespace().substring(flow.getNamespace().length() - 4))).comparison(Property.ofValue((Object)ExecutionNamespace.Comparison.SUFFIX)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void comparisonMismatchShouldPreferComparisonProperty() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionNamespace build = (ExecutionNamespace)JacksonMapper.toMap(Map.of("type", ExecutionNamespace.class.getName(), "namespace", flow.getNamespace().substring(flow.getNamespace().length() - 4), "prefix", true, "comparison", ExecutionNamespace.Comparison.SUFFIX.name()), ExecutionNamespace.class);
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }
}

