/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionOutputs;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ExecutionOutputsTest {
    @Inject
    ConditionService conditionService;

    ExecutionOutputsTest() {
    }

    @Test
    void shouldEvaluateToTrueGivenValidExpression() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of(), Map.of("test", "value"));
        ExecutionOutputs build = ExecutionOutputs.builder().expression(Property.ofExpression((String)"{{ trigger.outputs.test == 'value' }}")).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void shouldEvaluateToFalseGivenInvalidExpression() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of(), Map.of("test", "value"));
        ExecutionOutputs build = ExecutionOutputs.builder().expression(Property.ofExpression((String)"{{ unknown is defined }}")).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }

    @Test
    void shouldEvaluateToFalseGivenExecutionWithNoOutputs() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, Map.of());
        ExecutionOutputs build = ExecutionOutputs.builder().expression(Property.ofExpression((String)"{{ not evaluated }}")).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }
}

