/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionStatus;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ExecutionStatusTest {
    @Inject
    ConditionService conditionService;

    ExecutionStatusTest() {
    }

    @Test
    void in() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionStatus build = ExecutionStatus.builder().in(Property.ofValue(Collections.singletonList(State.Type.SUCCESS))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }

    @Test
    void notIn() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionStatus build = ExecutionStatus.builder().notIn(Property.ofValue(Collections.singletonList(State.Type.SUCCESS))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void both() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        ExecutionStatus build = ExecutionStatus.builder().in(Property.ofValue(Collections.singletonList(State.Type.CREATED))).notIn(Property.ofValue(Collections.singletonList(State.Type.SUCCESS))).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }
}

