/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.Expression;
import jakarta.inject.Inject;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class ExpressionTest {
    @Inject
    ConditionService conditionService;

    ExpressionTest() {
    }

    @Test
    void valid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of((Object)"test", (Object)"value"));
        Expression build = Expression.builder().expression(Property.ofExpression((String)"{{ flow.id }}")).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isTrue();
    }

    @Test
    void invalid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of((Object)"test", (Object)"value"));
        Expression build = Expression.builder().expression(Property.ofExpression((String)"{{ unknown is defined }}")).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isFalse();
    }
}

