/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.ExecutionStatus;
import io.kestra.plugin.core.condition.Expression;
import io.kestra.plugin.core.condition.MultipleCondition;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class MultipleConditionTest {
    @Inject
    ConditionService conditionService;
    @Inject
    MultipleConditionStorageInterface multipleConditionStorage;

    MultipleConditionTest() {
    }

    @Test
    void simple() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        MultipleCondition build = MultipleCondition.builder().conditions((Map)ImmutableMap.of((Object)"first", (Object)ExecutionStatus.builder().in(Property.ofValue(Collections.singletonList(State.Type.SUCCESS))).build(), (Object)"second", (Object)Expression.builder().expression(Property.ofExpression((String)"{{ flow.id }}")).build())).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution, this.multipleConditionStorage);
        Assertions.assertThat((boolean)test).isFalse();
    }
}

