/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.DayWeek;
import io.kestra.plugin.core.condition.Not;
import jakarta.inject.Inject;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class NotTest {
    @Inject
    ConditionService conditionService;

    NotTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.singletonList(DayWeek.builder().date(Property.ofValue((Object)"2013-09-08")).dayOfWeek(Property.ofValue((Object)DayOfWeek.SUNDAY)).build()), false}), Arguments.of((Object[])new Object[]{Arrays.asList(DayWeek.builder().date(Property.ofValue((Object)"2013-09-08")).dayOfWeek(Property.ofValue((Object)DayOfWeek.SATURDAY)).build(), DayWeek.builder().date(Property.ofValue((Object)"2013-09-08")).dayOfWeek(Property.ofValue((Object)DayOfWeek.MONDAY)).build()), true}), Arguments.of((Object[])new Object[]{Arrays.asList(DayWeek.builder().date(Property.ofValue((Object)"2013-09-08")).dayOfWeek(Property.ofValue((Object)DayOfWeek.SUNDAY)).build(), DayWeek.builder().date(Property.ofValue((Object)"2013-09-08")).dayOfWeek(Property.ofValue((Object)DayOfWeek.MONDAY)).build()), false}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(List<Condition> conditions, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        Not build = Not.builder().conditions(conditions).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

