/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.PublicHoliday;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@KestraTest
class PublicHolidayTest {
    @Inject
    ConditionService conditionService;
    @Inject
    private RunContextFactory runContextFactory;

    PublicHolidayTest() {
    }

    @Test
    void valid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        PublicHoliday publicHoliday = PublicHoliday.builder().date(Property.ofValue((Object)"2023-07-14")).country(Property.ofValue((Object)"FR")).build();
        Assertions.assertThat((boolean)this.conditionService.isValid((Condition)publicHoliday, (FlowInterface)flow, execution)).isTrue();
        publicHoliday = PublicHoliday.builder().date(Property.ofValue((Object)"2023-03-08")).country(Property.ofValue((Object)"DE")).subDivision(Property.ofValue((Object)"BE")).build();
        Assertions.assertThat((boolean)this.conditionService.isValid((Condition)publicHoliday, (FlowInterface)flow, execution)).isTrue();
    }

    @Test
    void invalid() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        PublicHoliday publicHoliday = PublicHoliday.builder().date(Property.ofValue((Object)"2023-01-02")).country(Property.ofValue((Object)"FR")).build();
        Assertions.assertThat((boolean)this.conditionService.isValid((Condition)publicHoliday, (FlowInterface)flow, execution)).isFalse();
        publicHoliday = PublicHoliday.builder().date(Property.ofValue((Object)"2023-03-08")).country(Property.ofValue((Object)"DE")).build();
        Assertions.assertThat((boolean)this.conditionService.isValid((Condition)publicHoliday, (FlowInterface)flow, execution)).isFalse();
    }

    @Test
    void validWithDynamicRender() {
        Flow flow = TestsUtils.mockFlow();
        Map<String, Map<String, String>> variables = Map.of("trigger", Map.of("date", "2023-07-14"));
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        PublicHoliday publicHoliday = PublicHoliday.builder().country(Property.ofValue((Object)"FR")).build();
        ConditionContext conditionContext = ConditionContext.builder().flow((FlowInterface)flow).execution(execution).runContext(this.runContextFactory.of((FlowInterface)flow, execution)).variables(variables).build();
        Assertions.assertThat((boolean)this.conditionService.valid((FlowInterface)flow, Collections.singletonList(publicHoliday), conditionContext)).isTrue();
    }

    @Test
    void invalidWithDynamicRender() {
        Flow flow = TestsUtils.mockFlow();
        Map<String, Map<String, String>> variables = Map.of("trigger", Map.of("date", "2023-01-02"));
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        PublicHoliday publicHoliday = PublicHoliday.builder().country(Property.ofValue((Object)"FR")).build();
        ConditionContext conditionContext = ConditionContext.builder().flow((FlowInterface)flow).execution(execution).runContext(this.runContextFactory.of((FlowInterface)flow, execution)).variables(variables).build();
        Assertions.assertThat((boolean)this.conditionService.valid((FlowInterface)flow, Collections.singletonList(publicHoliday), conditionContext)).isFalse();
    }

    @Test
    @Disabled(value="Locale is not deterministic on CI")
    void disabled() {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        PublicHoliday publicHoliday = PublicHoliday.builder().date(Property.ofValue((Object)"2023-01-01")).build();
        Assertions.assertThat((boolean)this.conditionService.isValid((Condition)publicHoliday, (FlowInterface)flow, execution)).isTrue();
    }
}

