/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.TimeBetween;
import jakarta.inject.Inject;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class TimeBetweenTest {
    @Inject
    ConditionService conditionService;

    TimeBetweenTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2024-02-21T16:19:12.00+02:00").toString(), null, OffsetTime.parse("16:19:11.000000+02:00").toString(), true}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2024-02-21T16:19:12.00+02:00").toString(), null, OffsetTime.parse("17:19:12.000000+02:00").toString(), false}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2024-02-21T16:19:12.00+02:00").toString(), OffsetTime.parse("16:20:12.000000+02:00"), OffsetTime.parse("16:18:12.000000+02:00"), true}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2024-02-21T16:19:12.00+02:00").toString(), OffsetTime.parse("16:20:12.000000+02:00"), null, true}), Arguments.of((Object[])new Object[]{ZonedDateTime.parse("2024-02-21T16:19:12.00+02:00").toString(), OffsetTime.parse("16:18:12.000000+02:00"), null, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(String date, OffsetTime before, OffsetTime after, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        TimeBetween build = TimeBetween.builder().date(Property.ofValue((Object)date)).before(Property.ofValue((Object)before)).after(Property.ofValue((Object)after)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

