/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.services.ConditionService;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.condition.Weekend;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@KestraTest
class WeekendTest {
    @Inject
    ConditionService conditionService;

    WeekendTest() {
    }

    static Stream<Arguments> source() {
        return Stream.of(Arguments.of((Object[])new Object[]{LocalDate.parse("2013-09-08").toString(), true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2013-09-07").toString(), true}), Arguments.of((Object[])new Object[]{LocalDate.parse("2013-09-07").toString(), true}), Arguments.of((Object[])new Object[]{"{{ \"2013-09-08T15:19:12.000000+02:00\" | date(\"iso_local_date\") }}", true}));
    }

    @ParameterizedTest
    @MethodSource(value={"source"})
    void valid(String date, boolean result) {
        Flow flow = TestsUtils.mockFlow();
        Execution execution = TestsUtils.mockExecution((FlowInterface)flow, (Map)ImmutableMap.of());
        Weekend build = Weekend.builder().date(date.startsWith("{{") ? Property.ofExpression((String)date) : Property.ofValue((Object)date)).build();
        boolean test = this.conditionService.isValid((Condition)build, (FlowInterface)flow, execution);
        Assertions.assertThat((boolean)test).isEqualTo(result);
    }
}

