/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.execution.Assert;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
public class AssertTest {
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;

    @Test
    void success() throws Exception {
        Assert task = ((Assert.AssertBuilder)((Assert.AssertBuilder)Assert.builder().id(IdUtils.create())).type(Assert.class.getName())).conditions(List.of("{{ inputs.key == 'value' }}", "{{ 42 == 42 }}")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of("key", "value"));
        task.run(runContext);
        Assertions.assertThat((Object)runContext.metrics().stream().filter(e -> e.getName().equals("success")).findFirst().orElseThrow().getValue()).isEqualTo((Object)2.0);
        Assertions.assertThat((Object)runContext.metrics().stream().filter(e -> e.getName().equals("failed")).findFirst().orElseThrow().getValue()).isEqualTo((Object)0.0);
    }

    @Test
    void failed() {
        ArrayList logs = new ArrayList();
        Flux receive = TestsUtils.receive(this.logQueue, l -> logs.add((LogEntry)l.getLeft()));
        Assert task = ((Assert.AssertBuilder)((Assert.AssertBuilder)Assert.builder().id(IdUtils.create())).type(Assert.class.getName())).conditions(List.of("{{ 42 == 42 }}", "{{ inputs.key == 'value1' }}", "{{ 42 == 42 }}", "{{ inputs.key == 'value2' }}", "{{ 42 == 42 }}")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of("key", "value"));
        Exception exception = (Exception)org.junit.Assert.assertThrows(Exception.class, () -> task.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"2 assertions failed"});
        List matchingLog = TestsUtils.awaitLogs(logs, (Integer)2);
        receive.blockLast();
        Assertions.assertThat((long)matchingLog.stream().filter(logEntry -> logEntry.getMessage().contains("inputs.key == 'value1'")).count()).isEqualTo(1L);
        Assertions.assertThat((long)matchingLog.stream().filter(logEntry -> logEntry.getMessage().contains("inputs.key == 'value2'")).count()).isEqualTo(1L);
        Assertions.assertThat((Object)runContext.metrics().stream().filter(e -> e.getName().equals("success")).findFirst().orElseThrow().getValue()).isEqualTo((Object)3.0);
        Assertions.assertThat((Object)runContext.metrics().stream().filter(e -> e.getName().equals("failed")).findFirst().orElseThrow().getValue()).isEqualTo((Object)2.0);
    }

    @Test
    @ExecuteFlow(value="flows/valids/assert.yaml")
    void dontFailOnCondition(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

