/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.statistics.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.repositories.AbstractExecutionRepositoryTest;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.execution.Count;
import jakarta.inject.Inject;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class CountTest {
    public static final String NAMESPACE = "io.kestra.unittest";
    @Inject
    TestRunContextFactory runContextFactory;
    @Inject
    ExecutionRepositoryInterface executionRepository;

    CountTest() {
    }

    @Test
    void run() throws Exception {
        String tenant = TestsUtils.randomTenant((String[])new String[]{this.getClass().getSimpleName()});
        for (int i = 0; i < 28; ++i) {
            this.executionRepository.save(AbstractExecutionRepositoryTest.builder(tenant, i < 5 ? State.Type.RUNNING : (i < 8 ? State.Type.FAILED : State.Type.SUCCESS), i < 4 ? "first" : (i < 10 ? "second" : "third")).build());
        }
        Count task = ((Count.CountBuilder)((Count.CountBuilder)Count.builder().id(IdUtils.create())).type(Count.class.getName())).flows(List.of(new Flow(NAMESPACE, "first"), new Flow(NAMESPACE, "second"), new Flow(NAMESPACE, "third"))).expression("{{ count >= 5 }}").startDate(Property.ofExpression((String)"{{ now() | dateAdd (-30, 'DAYS') }}")).endDate(Property.ofExpression((String)"{{ now() }}")).build();
        RunContext runContext = this.runContextFactory.of("id", NAMESPACE, tenant);
        Count.Output run = task.run(runContext);
        Assertions.assertThat((int)run.getResults().size()).isEqualTo(2);
        Assertions.assertThat((long)run.getResults().stream().filter(f -> f.getFlowId().equals("second")).count()).isEqualTo(1L);
        Assertions.assertThat((Long)run.getResults().stream().filter(f -> f.getFlowId().equals("second")).findFirst().get().getCount()).isEqualTo(6L);
        Assertions.assertThat((long)run.getResults().stream().filter(f -> f.getFlowId().equals("third")).count()).isEqualTo(1L);
        Assertions.assertThat((Long)run.getResults().stream().filter(f -> f.getFlowId().equals("third")).findFirst().get().getCount()).isEqualTo(18L);
        Assertions.assertThat((Long)run.getTotal()).isEqualTo(24L);
        run = Count.builder().flows(List.of(new Flow(NAMESPACE, "first"), new Flow(NAMESPACE, "second"), new Flow(NAMESPACE, "third"))).states(Property.ofValue(List.of(State.Type.RUNNING))).expression("{{ count >= 5 }}").build().run(runContext);
        Assertions.assertThat((int)run.getResults().size()).isZero();
        run = Count.builder().flows(List.of(new Flow("io.kestra.test", "missing"), new Flow(NAMESPACE, "second"), new Flow(NAMESPACE, "third"))).expression("{{ count == 0 }}").build().run(runContext);
        Assertions.assertThat((int)run.getResults().size()).isEqualTo(1);
        Assertions.assertThat((long)run.getResults().stream().filter(f -> f.getFlowId().equals("missing")).count()).isEqualTo(1L);
        Assertions.assertThat((Long)run.getTotal()).isEqualTo(0L);
    }
}

