/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class ExitTest {
    ExitTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/exit.yaml")
    void shouldExitTheExecution(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
    }

    @Test
    @ExecuteFlow(value="flows/valids/exit-killed.yaml")
    void shouldExitAndKillTheExecution(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.KILLED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/exit-nested.yaml")
    void shouldExitAndFailNestedIf(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("if_some_bool").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("nested_bool_check").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("nested_was_false").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

