/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class FailTest {
    @Inject
    private TestRunnerUtils runnerUtils;

    @Test
    @LoadFlows(value={"flows/valids/fail-on-switch.yaml"})
    void failOnSwitch() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "fail-on-switch", null, (f, e) -> Map.of("param", "fail"), Duration.ofSeconds(20L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("switch").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @LoadFlows(value={"flows/valids/fail-on-condition.yaml"}, tenantId="fail")
    void failOnCondition() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("fail", "io.kestra.tests", "fail-on-condition", null, (f, e) -> Map.of("param", "fail"), Duration.ofSeconds(20L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("fail").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @LoadFlows(value={"flows/valids/fail-on-condition.yaml"}, tenantId="success")
    void dontFailOnCondition() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("success", "io.kestra.tests", "fail-on-condition", null, (f, e) -> Map.of("param", "success"), Duration.ofSeconds(20L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("fail").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

