/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.plugin.core.execution.PurgeExecutions;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest
class PurgeExecutionsTest {
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private ExecutionRepositoryInterface executionRepository;

    PurgeExecutionsTest() {
    }

    @Test
    void run() throws Exception {
        String namespace = "run.namespace";
        String flowId = "run-flow-id";
        Execution execution = Execution.builder().id(IdUtils.create()).namespace(namespace).flowId(flowId).tenantId("main").state(new State().withState(State.Type.SUCCESS)).build();
        this.executionRepository.save(execution);
        PurgeExecutions purge = PurgeExecutions.builder().flowId(Property.ofValue((Object)flowId)).namespace(Property.ofValue((Object)namespace)).endDate(Property.ofValue((Object)ZonedDateTime.now().plusMinutes(1L).format(DateTimeFormatter.ISO_ZONED_DATE_TIME))).build();
        RunContext runContext = this.runContextFactory.of(flowId, namespace);
        PurgeExecutions.Output output = purge.run(runContext);
        Assertions.assertThat((int)output.getExecutionsCount()).isEqualTo(1);
    }

    @Test
    void deleted() throws Exception {
        String namespace = "deleted.namespace";
        String flowId = "deleted-flow-id";
        Execution execution = Execution.builder().namespace(namespace).flowId(flowId).id(IdUtils.create()).tenantId("main").state(new State().withState(State.Type.SUCCESS)).build();
        this.executionRepository.save(execution);
        this.executionRepository.delete(execution);
        PurgeExecutions purge = PurgeExecutions.builder().namespace(Property.ofValue((Object)namespace)).flowId(Property.ofValue((Object)flowId)).endDate(Property.ofValue((Object)ZonedDateTime.now().plusMinutes(1L).format(DateTimeFormatter.ISO_ZONED_DATE_TIME))).build();
        RunContext runContext = this.runContextFactory.of(flowId, namespace);
        PurgeExecutions.Output output = purge.run(runContext);
        Assertions.assertThat((int)output.getExecutionsCount()).isEqualTo(1);
    }
}

