/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.Await;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class ResumeTest {
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private ExecutionRepositoryInterface executionRepository;

    ResumeTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/pause-test.yaml", "flows/valids/resume-execution.yaml"})
    void resume() throws Exception {
        Execution pause = this.runnerUtils.runOneUntilPaused("main", "io.kestra.tests", "pause-test");
        String pauseId = pause.getId();
        Execution resume = this.runnerUtils.runOne("main", "io.kestra.tests", "resume-execution", null, (flow, execution) -> Map.of("executionId", pauseId));
        Assertions.assertThat((Comparable)resume.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Await.until(() -> ((Execution)this.executionRepository.findById("main", pauseId).orElseThrow()).getState().getCurrent().isTerminated(), (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(5L));
    }
}

