/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class AllowFailureTest {
    @Inject
    private FlowInputOutput flowIO;
    @Inject
    protected TestRunnerUtils runnerUtils;

    AllowFailureTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/allow-failure.yaml")
    void success(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        AllowFailureTest.control(execution);
        Assertions.assertThat((int)execution.findTaskRunsByTaskId("global-error").size()).isZero();
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("last").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
    }

    @Test
    @LoadFlows(value={"flows/valids/allow-failure.yaml"}, tenantId="fail")
    void failed() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("fail", "io.kestra.tests", "allow-failure", null, (f, e) -> this.flowIO.readExecutionInputs(f, e, (Map)ImmutableMap.of((Object)"crash", (Object)"1")));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(10);
        AllowFailureTest.control(execution);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("global-error").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("switch").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("crash").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/allow-failure-with-retry.yaml")
    void withRetry(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("retry_block").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((int)((TaskRun)execution.findTaskRunsByTaskId("failing_task").getFirst()).attemptNumber()).isEqualTo(3);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("failing_task").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)execution.findTaskRunsByTaskId("error_handler").size()).isEqualTo(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("finally_task").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("downstream_task").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    private static void control(Execution execution) {
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("first").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("1-1-allow-failure").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("1-1-1_seq").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("1-1-1-1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("local-error").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("1-2-todo").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

