/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.serializers.JacksonMapper;
import java.util.List;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class BadFlowableTest {
    @Test
    @ExecuteFlow(value="flows/valids/flowable-fail.yaml")
    void sequential(Execution execution) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)execution.getTaskRunList().size()).as("Task runs were: \n" + JacksonMapper.log((Object)execution.getTaskRunList()), new Object[0])).isGreaterThanOrEqualTo(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/flowable-with-parent-fail.yaml")
    void flowableWithParentFail(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

