/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
class CorrelationIdTest {
    @Inject
    @Named(value="executionQueue")
    private QueueInterface<Execution> executionQueue;
    @Inject
    private TestRunnerUtils runnerUtils;

    CorrelationIdTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/subflow-parent.yaml", "flows/valids/subflow-child.yaml", "flows/valids/subflow-grand-child.yaml"})
    void shouldHaveCorrelationId() throws QueueException, TimeoutException, InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        AtomicReference child = new AtomicReference();
        AtomicReference grandChild = new AtomicReference();
        Flux receive = TestsUtils.receive(this.executionQueue, either -> {
            Execution execution = (Execution)either.getLeft();
            if (execution.getFlowId().equals("subflow-child") && execution.getState().getCurrent().isTerminated()) {
                child.set(execution);
                countDownLatch.countDown();
            }
            if (execution.getFlowId().equals("subflow-grand-child") && execution.getState().getCurrent().isTerminated()) {
                grandChild.set(execution);
                countDownLatch.countDown();
            }
        });
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "subflow-parent");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)countDownLatch.await(1L, TimeUnit.MINUTES));
        receive.blockLast();
        Assertions.assertThat((Object)((Execution)child.get())).isNotNull();
        Assertions.assertThat((Comparable)((Execution)child.get()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Optional<Label> correlationId = ((Execution)child.get()).getLabels().stream().filter(label -> label.key().equals("system.correlationId")).findAny();
        Assertions.assertThat((boolean)correlationId.isPresent()).isTrue();
        Assertions.assertThat((String)correlationId.get().value()).isEqualTo(execution.getId());
        Assertions.assertThat((Object)((Execution)grandChild.get())).isNotNull();
        Assertions.assertThat((Comparable)((Execution)grandChild.get()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        correlationId = ((Execution)grandChild.get()).getLabels().stream().filter(label -> label.key().equals("system.correlationId")).findAny();
        Assertions.assertThat((boolean)correlationId.isPresent()).isTrue();
        Assertions.assertThat((String)correlationId.get().value()).isEqualTo(execution.getId());
    }
}

