/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class DagTest {
    @Inject
    ModelValidator modelValidator;
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    private FlowInputOutput flowIO;

    @Test
    @ExecuteFlow(value="flows/valids/dag.yaml")
    void dag(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(7);
    }

    @Test
    void dagCyclicDependencies() {
        Flow flow = this.parse("flows/invalids/dag-cyclicdependency.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)((Object)validate.get())).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)((Object)validate.get())).getMessage()).contains(new CharSequence[]{"dag: Cyclic dependency detected: task1, task2"});
    }

    @Test
    void dagNotExistTask() {
        Flow flow = this.parse("flows/invalids/dag-notexist-task.yaml");
        Optional validate = this.modelValidator.isValid((Object)flow);
        Assertions.assertThat((boolean)validate.isPresent()).isTrue();
        Assertions.assertThat((int)((ConstraintViolationException)((Object)validate.get())).getConstraintViolations().size()).isEqualTo(1);
        Assertions.assertThat((String)((ConstraintViolationException)((Object)validate.get())).getMessage()).contains(new CharSequence[]{"dag: Not existing task id in dependency: taskX"});
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-dag.yaml"})
    void errors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "finally-dag", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((boolean)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getStartDate().isAfter((Instant)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getEndDate().orElseThrow())).isTrue();
        Assertions.assertThat((boolean)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getStartDate().isAfter((Instant)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getEndDate().orElseThrow())).isTrue();
    }

    private Flow parse(String path) {
        URL resource = TestsUtils.class.getClassLoader().getResource(path);
        assert (resource != null);
        File file = new File(resource.getFile());
        return (Flow)YamlParser.parse((File)file, Flow.class);
    }
}

