/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class EachParallelTest {
    @Test
    @ExecuteFlow(value="flows/valids/each-parallel.yaml")
    void parallel(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel-nested.yaml")
    void parallelNested(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel-Integer.yml")
    void parallelInteger(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-parallel-disabled-tasks.yaml")
    void disabledTasks(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
    }
}

