/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
public class EachSequentialTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> logQueue;
    @Inject
    private TestRunnerUtils runnerUtils;

    @Test
    @ExecuteFlow(value="flows/valids/each-sequential.yaml")
    void sequential(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-object.yaml")
    void object(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.getTaskRunList().get(6)).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"json > JSON > [\"my-complex\"]"});
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-object-in-list.yaml")
    void objectInList(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((TaskRun)execution.getTaskRunList().get(6)).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"json > JSON > [\"my-complex\"]"});
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-sequential-nested.yaml")
    void sequentialNested(Execution execution) throws InternalException {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(23);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun last = (TaskRun)execution.findTaskRunsByTaskId("2_return").getFirst();
        TaskRun lastWithValue = execution.findTaskRunByTaskIdAndValue("1-2-1_return", Arrays.asList("s1", "a a"));
        Assertions.assertThat((String)((String)last.getOutputs().get((Object)"value"))).contains(new CharSequence[]{(String)lastWithValue.getOutputs().get((Object)"value")});
        TaskRun evalL1 = execution.findTaskRunByTaskIdAndValue("1-3_return", Collections.singletonList("s1"));
        TaskRun evalL1Lookup = execution.findTaskRunByTaskIdAndValue("1-1_return", Collections.singletonList("s1"));
        Assertions.assertThat((String)((String)evalL1.getOutputs().get((Object)"value"))).contains(new CharSequence[]{(String)evalL1Lookup.getOutputs().get((Object)"value")});
        TaskRun evalL2 = execution.findTaskRunByTaskIdAndValue("1-2-2_return", Arrays.asList("s1", "a a"));
        TaskRun evalL2Lookup = execution.findTaskRunByTaskIdAndValue("1-2-1_return", Arrays.asList("s1", "a a"));
        Assertions.assertThat((String)((String)evalL2.getOutputs().get((Object)"value"))).contains(new CharSequence[]{"get " + (String)evalL2Lookup.getOutputs().get((Object)"value")});
        Assertions.assertThat((String)((String)evalL2.getOutputs().get((Object)"value"))).contains(new CharSequence[]{(String)evalL2Lookup.getOutputs().get((Object)"value")});
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-empty.yaml")
    void eachEmpty(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/each-null.yaml"})
    void eachNull() throws TimeoutException, QueueException {
        EachSequentialTest.eachNullTest(this.runnerUtils, this.logQueue);
    }

    public static void eachNullTest(TestRunnerUtils runnerUtils, QueueInterface<LogEntry> logQueue) throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "each-null", Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, logEntry -> logEntry.getMessage().contains("Found '1' null values on Each, with values=[1, null, {key=my-key, value=my-value}]"));
        receive.blockLast();
        Assertions.assertThat((Object)matchingLog).isNotNull();
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-switch.yaml")
    void eachSwitch(Execution execution) throws InternalException {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(12);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        TaskRun switchNumber1 = execution.findTaskRunByTaskIdAndValue("2-1-1_switch-number-1", Arrays.asList("b", "1"));
        Assertions.assertThat((String)((String)switchNumber1.getOutputs().get((Object)"value"))).isEqualTo("1");
        TaskRun switchNumber2 = execution.findTaskRunByTaskIdAndValue("2-1-1_switch-number-2", Arrays.asList("b", "2"));
        Assertions.assertThat((String)((String)switchNumber2.getOutputs().get((Object)"value"))).isEqualTo("2 b");
    }

    @Test
    @ExecuteFlow(value="flows/valids/each-disabled-tasks.yaml")
    void eachDisabledTasks(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

