/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class FinallyTest {
    public static final String NAMESPACE = "io.kestra.tests";
    private static final String TENANT_ID = "tenant1";
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    private FlowInputOutput flowIO;

    FinallyTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-sequential.yaml"})
    void sequentialWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-sequential", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-sequential.yaml"}, tenantId="tenant1")
    void sequentialWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-sequential", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-sequential-error.yaml"})
    void sequentialErrorBlockWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-sequential-error", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-sequential-error-first.yaml"})
    void sequentialErrorFirst() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-sequential-error-first");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((boolean)execution.findTaskRunsByTaskId("ok").isEmpty()).isTrue();
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-sequential-error.yaml"}, tenantId="tenant1")
    void sequentialErrorBlockWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-sequential-error", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-allowfailure.yaml"})
    void allowFailureWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-allowfailure", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-allowfailure.yaml"}, tenantId="tenant1")
    void allowFailureWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-allowfailure", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-parallel.yaml"})
    void parallelWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-parallel", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-parallel.yaml"}, tenantId="tenant1")
    void parallelWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-parallel", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(10);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-foreach.yaml"}, tenantId="tenant1")
    void forEachWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-foreach", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-foreach.yaml"})
    void forEachWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-foreach", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-eachparallel.yaml"})
    void eachParallelWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-eachparallel", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-eachparallel.yaml"}, tenantId="tenant1")
    void eachParallelWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-eachparallel", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-dag.yaml"}, tenantId="tenant1")
    void dagWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-dag", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-dag.yaml"})
    void dagWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-dag", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-flow.yaml"})
    void flowWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-flow", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-flow.yaml"}, tenantId="tenant1")
    void flowWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-flow", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-flow-error.yaml"})
    void flowErrorBlockWithoutErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-flow-error", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", false)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ok").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-flow-error.yaml"}, tenantId="tenant1")
    void flowErrorBlockWithErrors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, NAMESPACE, "finally-flow-error", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(20L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-flow-error-first.yaml"})
    void flowErrorFirst() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, "finally-flow-error-first");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((boolean)execution.findTaskRunsByTaskId("ok").isEmpty()).isTrue();
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

