/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;

@Singleton
public class FlowCaseTest {
    @Inject
    protected TestRunnerUtils runnerUtils;

    public void waitSuccess() throws Exception {
        this.run("OK", State.Type.SUCCESS, State.Type.SUCCESS, 2, "default > amazing", true);
    }

    public void waitFailed(String tenantId) throws Exception {
        this.run("THIRD", State.Type.FAILED, State.Type.FAILED, 4, "Error Trigger ! error-t1", true, tenantId);
    }

    public void invalidOutputs(String tenantId) throws Exception {
        this.run("FIRST", State.Type.FAILED, State.Type.SUCCESS, 2, null, true, tenantId);
    }

    public void noLabels(String tenantId) throws Exception {
        this.run("OK", State.Type.SUCCESS, State.Type.SUCCESS, 2, "default > amazing", false, tenantId);
    }

    public void oldTaskName() throws Exception {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "subflow-old-task-name");
        Execution triggered = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().isTerminated(), "main", "io.kestra.tests", "minimal");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"executionId")).isEqualTo((Object)triggered.getId());
        Assertions.assertThat((String)triggered.getTrigger().getType()).isEqualTo("io.kestra.core.tasks.flows.Subflow");
        Assertions.assertThat(triggered.getTrigger().getVariables().get("executionId")).isEqualTo((Object)execution.getId());
        Assertions.assertThat(triggered.getTrigger().getVariables().get("flowId")).isEqualTo((Object)execution.getFlowId());
        Assertions.assertThat(triggered.getTrigger().getVariables().get("namespace")).isEqualTo((Object)execution.getNamespace());
    }

    void run(String input, State.Type fromState, State.Type triggerState, int count, String outputs, boolean testInherited) throws Exception {
        this.run(input, fromState, triggerState, count, outputs, testInherited, "main");
    }

    void run(String input, State.Type fromState, State.Type triggerState, int count, String outputs, boolean testInherited, String tenantId) throws Exception {
        Execution execution = this.runnerUtils.runOne(tenantId, "io.kestra.tests", testInherited ? "task-flow" : "task-flow-inherited-labels", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)input), Duration.ofMinutes(1L), testInherited ? List.of(new Label("mainFlowExecutionLabel", "execFoo")) : List.of());
        Execution triggered = this.runnerUtils.awaitFlowExecution(e -> e.getState().getCurrent().isTerminated(), tenantId, "io.kestra.tests", "switch");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRunAttempt)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts().getFirst()).getState().getCurrent()).isEqualTo((Object)fromState);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)fromState);
        if (outputs != null) {
            Assertions.assertThat((String)((String)((Map)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"outputs")).get("extracted"))).contains(new CharSequence[]{outputs});
        }
        Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"executionId")).isEqualTo((Object)triggered.getId());
        if (outputs != null) {
            Assertions.assertThat((Object)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"state")).isEqualTo((Object)triggered.getState().getCurrent().name());
        }
        Assertions.assertThat((String)triggered.getTrigger().getType()).isEqualTo("io.kestra.plugin.core.flow.Subflow");
        Assertions.assertThat(triggered.getTrigger().getVariables().get("executionId")).isEqualTo((Object)execution.getId());
        Assertions.assertThat(triggered.getTrigger().getVariables().get("flowId")).isEqualTo((Object)execution.getFlowId());
        Assertions.assertThat(triggered.getTrigger().getVariables().get("namespace")).isEqualTo((Object)execution.getNamespace());
        Assertions.assertThat((List)triggered.getTaskRunList()).hasSize(count);
        Assertions.assertThat((Comparable)triggered.getState().getCurrent()).isEqualTo((Object)triggerState);
        if (testInherited) {
            Assertions.assertThat((int)triggered.getLabels().size()).isEqualTo(6);
            Assertions.assertThat((List)triggered.getLabels()).contains((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("mainFlowExecutionLabel", "execFoo"), new Label("mainFlowLabel", "flowFoo"), new Label("launchTaskLabel", "launchFoo"), new Label("switchFlowLabel", "switchFoo"), new Label("overriding", "child")});
        } else {
            Assertions.assertThat((int)triggered.getLabels().size()).isEqualTo(4);
            Assertions.assertThat((List)triggered.getLabels()).contains((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("launchTaskLabel", "launchFoo"), new Label("switchFlowLabel", "switchFoo"), new Label("overriding", "child")});
            Assertions.assertThat((List)triggered.getLabels()).doesNotContain((Object[])new Label[]{new Label("inherited", "label")});
        }
    }
}

