/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class FlowOutputTest {
    FlowOutputTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/flow-with-outputs.yml")
    void shouldGetSuccessExecutionForFlowWithOutputs(Execution execution) {
        Assertions.assertThat((Map)execution.getOutputs()).hasSize(1);
        Assertions.assertThat(execution.getOutputs().get("key")).isEqualTo((Object)"{\"value\":\"flow-with-outputs\"}");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/flow-with-optional-outputs.yml")
    void shouldGetSuccessExecutionForFlowWithOptionalOutputs(Execution execution) {
        Assertions.assertThat((Map)execution.getOutputs()).isNull();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/flow-with-array-outputs.yml")
    void shouldGetSuccessExecutionForFlowWithArrayOutputs(Execution execution) {
        Assertions.assertThat((Map)execution.getOutputs()).hasSize(1);
        Assertions.assertThat((List)((List)execution.getOutputs().get("myout"))).contains((Object[])new String[]{"1rstValue", "2ndValue"});
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/flow-with-outputs-failed.yml")
    void shouldGetFailExecutionForFlowWithInvalidOutputs(Execution execution) {
        Assertions.assertThat((Map)execution.getOutputs()).isNull();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

