/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.plugin.core.flow.FlowCaseTest;
import jakarta.inject.Inject;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class FlowTest {
    @Inject
    FlowCaseTest flowCaseTest;

    FlowTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml", "flows/valids/switch.yaml"})
    void waitSuccess() throws Exception {
        this.flowCaseTest.waitSuccess();
    }

    @Test
    @LoadFlows(value={"flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml", "flows/valids/switch.yaml"}, tenantId="tenant1")
    void waitFailed() throws Exception {
        this.flowCaseTest.waitFailed("tenant1");
    }

    @Test
    @LoadFlows(value={"flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml", "flows/valids/switch.yaml"}, tenantId="tenant2")
    void invalidOutputs() throws Exception {
        this.flowCaseTest.invalidOutputs("tenant2");
    }

    @Test
    @LoadFlows(value={"flows/valids/task-flow.yaml", "flows/valids/task-flow-inherited-labels.yaml", "flows/valids/switch.yaml"}, tenantId="tenant3")
    void noLabels() throws Exception {
        this.flowCaseTest.noLabels("tenant3");
    }

    @Test
    @LoadFlows(value={"flows/valids/subflow-old-task-name.yaml", "flows/valids/minimal.yaml"})
    void oldTaskName() throws Exception {
        this.flowCaseTest.oldTaskName();
    }
}

