/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class ForEachTest {
    ForEachTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-non-concurrent.yaml")
    void nonConcurrent(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-concurrent.yaml")
    void concurrent(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-concurrent-parallel.yaml")
    void concurrentWithParallel(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(10);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-concurrent-no-limit.yaml")
    void concurrentNoLimit(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(7);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-disabled-tasks.yaml")
    void disabledTasks(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-error.yaml")
    void errors(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-nested.yaml")
    void nested(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/foreach-iteration.yaml")
    void iteration(Execution execution) throws InternalException {
        List seconds = execution.findTaskRunsByTaskId("second");
        Assertions.assertThat((List)seconds).hasSize(2);
        Assertions.assertThat((Integer)((TaskRun)seconds.get(0)).getIteration()).isEqualTo(0);
        Assertions.assertThat((Integer)((TaskRun)seconds.get(1)).getIteration()).isEqualTo(1);
    }
}

