/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class IfTest {
    private static final String TENANT_ID = "true";
    @Inject
    private TestRunnerUtils runnerUtils;

    IfTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/if-condition.yaml"}, tenantId="true")
    void ifTruthy() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne(TENANT_ID, "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", true), Duration.ofSeconds(120L));
        List flowableAttempts = ((TaskRun)execution.findTaskRunsByTaskId("if").getFirst()).getAttempts();
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-true").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)flowableAttempts).isNotNull();
        Assertions.assertThat((Comparable)((TaskRunAttempt)flowableAttempts.getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne(TENANT_ID, "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", TENANT_ID), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-true").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne(TENANT_ID, "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", 1), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-true").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/if-condition.yaml"})
    void ifFalsy() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", false), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-false").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", "false"), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-false").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", 0), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-false").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-condition", null, (f, e) -> Map.of("param", 0), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-false").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/if-without-else.yaml"})
    void ifWithoutElse() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-without-else", null, (f, e) -> Map.of("param", true), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("when-true").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-without-else", null, (f, e) -> Map.of("param", false), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((boolean)execution.findTaskRunsByTaskId("when-true").isEmpty()).isTrue();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @LoadFlows(value={"flows/valids/if-in-flowable.yaml"})
    void ifInFlowable() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "if-in-flowable", null, (f, e) -> Map.of("param", true), Duration.ofSeconds(120L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("after_if").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/if-with-only-disabled-tasks.yaml")
    void ifWithOnlyDisabledTasks(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("if").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/if-in-parallel.yaml")
    void ifOnParallelBranch(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(9);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

