/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

public class LoopUntilCaseTest {
    @Inject
    protected TestRunnerUtils runnerUtils;

    public void waitfor() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Map)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs()).isNotNull();
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"iterationCount"))).isEqualTo(1);
    }

    public void waitforMaxIterations() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-max-iterations");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Map)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs()).isNotNull();
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"iterationCount"))).isEqualTo(4);
    }

    public void waitforMaxDuration() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-max-duration");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void waitforNoSuccess() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-no-success");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Map)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs()).isNotNull();
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"iterationCount"))).isEqualTo(5);
    }

    public void waitforMultipleTasks() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-multiple-tasks");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Map)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs()).isNotNull();
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"iterationCount"))).isEqualTo(3);
        Map values = (Map)((TaskRun)execution.getTaskRunList().getLast()).getOutputs().get((Object)"values");
        Assertions.assertThat(values.get("count")).isEqualTo((Object)"4");
    }

    public void waitforMultipleTasksFailed() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-multiple-tasks-failed");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().getLast()).attemptNumber()).isEqualTo(1);
    }

    public void waitForChildTaskWarning() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "waitfor-child-task-warning");
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.getTaskRunList().getFirst()).getOutputs().get((Object)"iterationCount"))).isGreaterThan(1);
    }
}

