/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class ParallelTest {
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    private FlowInputOutput flowIO;

    ParallelTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/parallel.yaml")
    void parallel(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
    }

    @Test
    @ExecuteFlow(value="flows/valids/parallel-nested.yaml")
    void parallelNested(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
    }

    @Test
    @LoadFlows(value={"flows/valids/finally-parallel.yaml"})
    void errors() throws QueueException, TimeoutException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "finally-parallel", null, (flow, execution1) -> this.flowIO.readExecutionInputs(flow, execution1, Map.of("failed", true)), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(10);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("ko").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((boolean)((TaskRun)execution.findTaskRunsByTaskId("a2").getFirst()).getState().getStartDate().isAfter((Instant)((TaskRun)execution.findTaskRunsByTaskId("a1").getFirst()).getState().getEndDate().orElseThrow())).isTrue();
        Assertions.assertThat((boolean)((TaskRun)execution.findTaskRunsByTaskId("e2").getFirst()).getState().getStartDate().isAfter((Instant)((TaskRun)execution.findTaskRunsByTaskId("e1").getFirst()).getState().getEndDate().orElseThrow())).isTrue();
    }

    @Test
    @ExecuteFlow(value="flows/valids/parallel-fail-with-flowable.yaml")
    void parallelFailWithFlowable(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        execution.getTaskRunList().stream().filter(taskRun -> !"sleep".equals(taskRun.getTaskId())).forEach(run -> Assertions.assertThat((boolean)run.getState().isTerminated()).isTrue());
    }
}

