/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.repositories.ArrayListTotal;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.Await;
import io.micronaut.data.model.Pageable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RetryCaseTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryCaseTest.class);
    @Inject
    protected TestRunnerUtils runnerUtils;
    @Inject
    private ExecutionRepositoryInterface executionRepository;
    @Inject
    private FlowRepositoryInterface flowRepository;

    public void retrySuccess(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(4);
    }

    public void retrySuccessAtFirstAttempt(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(1);
    }

    public void retryFailed(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void retryRandom(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void retryExpo(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void retryFail(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((List)((TaskRun)execution.getTaskRunList().getFirst()).getAttempts()).hasSize(3);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void retryNewExecutionTaskDuration(String tenant) throws TimeoutException, QueueException {
        Flow flow = (Flow)this.flowRepository.findById(tenant, "io.kestra.tests", "retry-new-execution-task-duration").orElseThrow();
        this.runAndAssertThereWasTwoRetriesAndFinishedFailed(flow);
    }

    public void retryNewExecutionTaskAttempts(String tenant) throws TimeoutException, QueueException {
        Flow flow = (Flow)this.flowRepository.findById(tenant, "io.kestra.tests", "retry-new-execution-task-attempts").orElseThrow();
        this.runAndAssertThereWasTwoRetriesAndFinishedFailed(flow);
    }

    public void retryNewExecutionFlowDuration(String tenant) throws TimeoutException, QueueException {
        Flow flow = (Flow)this.flowRepository.findById(tenant, "io.kestra.tests", "retry-new-execution-flow-duration").orElseThrow();
        this.runAndAssertThereWasTwoRetriesAndFinishedFailed(flow);
    }

    public void retryNewExecutionFlowAttempts(String tenant) throws TimeoutException, QueueException {
        Flow flow = (Flow)this.flowRepository.findById(tenant, "io.kestra.tests", "retry-new-execution-flow-attempts").orElseThrow();
        this.runAndAssertThereWasTwoRetriesAndFinishedFailed(flow);
    }

    private void runAndAssertThereWasTwoRetriesAndFinishedFailed(Flow flow) throws TimeoutException, QueueException {
        this.runnerUtils.runOne(Execution.newExecution((FlowInterface)flow, null), flow, Duration.ofSeconds(10L));
        Await.until(() -> "flow should have ended in Failed state", () -> this.executionRepository.findLatestForStates(flow.getTenantId(), flow.getNamespace(), flow.getId(), List.of(State.Type.FAILED)).isPresent(), (Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(10L));
        ArrayListTotal executions = this.executionRepository.findByFlowId(flow.getTenantId(), flow.getNamespace(), flow.getId(), Pageable.UNPAGED);
        Assertions.assertThat(executions.stream().map(e -> e.getState().getCurrent())).contains((Object[])new State.Type[]{State.Type.RETRIED, State.Type.RETRIED, State.Type.FAILED});
    }

    public void retryFailedTaskDuration(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().getFirst()).attemptNumber()).isGreaterThanOrEqualTo(2);
    }

    public void retryFailedTaskAttempts(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().getFirst()).attemptNumber()).isEqualTo(4);
    }

    public void retryFailedFlowDuration(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().getFirst()).attemptNumber()).isEqualTo(3);
    }

    public void retryFailedFlowAttempts(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().getFirst()).attemptNumber()).isEqualTo(4);
    }

    public void retryFlowable(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(1)).attemptNumber()).isEqualTo(3);
    }

    public void retrySubflow(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(0)).getAttempts().size()).isEqualTo(3);
    }

    public void retryFlowableChild(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(1)).attemptNumber()).isEqualTo(3);
    }

    public void retryFlowableNestedChild(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(2)).attemptNumber()).isEqualTo(3);
    }

    public void retryFlowableParallel(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(1)).attemptNumber()).isGreaterThanOrEqualTo(2);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(2)).attemptNumber()).isGreaterThanOrEqualTo(2);
    }

    public void retryDynamicTask(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    public void retryWithFlowableErrors(Execution execution) {
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((int)((TaskRun)execution.getTaskRunList().get(2)).attemptNumber()).isEqualTo(2);
    }
}

