/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class RuntimeLabelsTest {
    @Inject
    private TestRunnerUtils runnerUtils;

    RuntimeLabelsTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/labels-update-task.yml"})
    void update() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "labels-update-task", null, (flow, createdExecution) -> Map.of("labelsJson", "{\"keyFromJson\": \"valueFromJson\"}", "labelsMapKey", "keyFromMap", "labelsMapValue", "valueFromMap", "labelsListKey", "keyFromList", "labelsListValue", "valueFromList"), null, List.of(new Label("keyFromExecution", "valueFromExecution"), new Label("overriddenExecutionLabelKey", "executionValueThatWillGetOverridden")));
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        String labelsOverriderTaskRunId = ((TaskRun)execution.findTaskRunsByTaskId("override-labels").getFirst()).getId();
        Assertions.assertThat((List)execution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("flowLabelKey", "flowLabelValue"), new Label("overriddenFlowLabelKey", "io.kestra.tests.labels-update-task"), new Label("keyFromJson", "valueFromJson"), new Label("keyFromMap", "valueFromMap"), new Label("keyFromList", "valueFromList"), new Label("keyFromExecution", "valueFromExecution"), new Label("overriddenExecutionLabelKey", labelsOverriderTaskRunId)});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("override-labels").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(3);
        Assertions.assertThat((List)labelRunAttempt.getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    @ExecuteFlow(value="flows/valids/npe-labels-update-task.yml")
    void noNpeOnNullPreviousExecutionLabels(Execution execution) {
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        String labelsTaskRunId = ((TaskRun)execution.findTaskRunsByTaskId("labels").getFirst()).getId();
        Assertions.assertThat((List)execution.getLabels()).contains((Object[])new Label[]{new Label("someLabel", labelsTaskRunId)});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("labels").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(3);
        Assertions.assertThat((List)labelRunAttempt.getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    @LoadFlows(value={"flows/valids/primitive-labels-flow.yml"})
    void primitiveTypeLabels() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "primitive-labels-flow", null, (flow, createdExecution) -> Map.of("intLabel", 42, "boolLabel", true, "floatLabel", Float.valueOf(3.14f)), null, List.of(new Label("existingLabel", "someValue")));
        Assertions.assertThat((int)execution.getTaskRunList().size()).isEqualTo(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        String labelsTaskRunId = ((TaskRun)execution.findTaskRunsByTaskId("update-labels").getFirst()).getId();
        Assertions.assertThat((List)execution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("intValue", "42"), new Label("boolValue", "true"), new Label("floatValue", "3.14"), new Label("taskRunId", labelsTaskRunId), new Label("existingLabel", "someValue")});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("update-labels").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(3);
        Assertions.assertThat((List)labelRunAttempt.getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    @LoadFlows(value={"flows/valids/primitive-labels-flow.yml"}, tenantId="tenant1")
    void primitiveTypeLabelsOverrideExistingLabels() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("tenant1", "io.kestra.tests", "primitive-labels-flow", null, (flow, createdExecution) -> Map.of("intLabel", 42, "boolLabel", true, "floatLabel", Float.valueOf(3.14f)), null, List.of(new Label("intValue", "1"), new Label("boolValue", "false"), new Label("floatValue", "4.2f")));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        String labelsTaskRunId = ((TaskRun)execution.findTaskRunsByTaskId("update-labels").getFirst()).getId();
        Assertions.assertThat((List)execution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("intValue", "42"), new Label("boolValue", "true"), new Label("floatValue", "3.14"), new Label("taskRunId", labelsTaskRunId)});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("update-labels").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(3);
        Assertions.assertThat((List)labelRunAttempt.getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    @LoadFlows(value={"flows/valids/labels-update-task-deduplicate.yml"})
    void updateGetsDeduplicated() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "labels-update-task-deduplicate", null, (flow, createdExecution) -> Map.of(), null, List.of());
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)execution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", execution.getId()), new Label("fromStringKey", "value2"), new Label("fromListKey", "value2")});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("from-string").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(3);
        Assertions.assertThat((List)labelRunAttempt.getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    @LoadFlows(value={"flows/valids/labels-update-task-empty.yml"})
    void updateIgnoresEmpty() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "labels-update-task-empty", null, (flow, createdExecution) -> Map.of(), null, List.of());
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((List)execution.getLabels()).containsExactly((Object[])new Label[]{new Label("system.correlationId", execution.getId())});
        TaskRun labelTaskRun = (TaskRun)execution.findTaskRunsByTaskId("from-string").getFirst();
        TaskRunAttempt labelRunAttempt = labelTaskRun.lastAttempt();
        Assertions.assertThat((Comparable)labelRunAttempt.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((int)labelRunAttempt.getState().getHistories().size()).isEqualTo(1);
    }
}

