/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class SequentialTest {
    SequentialTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/sequential.yaml")
    void sequential(Execution execution) {
        List flowableAttempts = ((TaskRun)execution.findTaskRunsByTaskId("1-seq").getFirst()).getAttempts();
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(11);
        Assertions.assertThat((List)flowableAttempts).isNotNull();
        Assertions.assertThat((Comparable)((TaskRunAttempt)flowableAttempts.getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }

    @Test
    @ExecuteFlow(value="flows/valids/sequential-with-global-errors.yaml")
    void sequentialWithGlobalErrors(Execution execution) {
        List flowableAttempts = ((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getAttempts();
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((List)flowableAttempts).isNotNull();
        Assertions.assertThat((Comparable)((TaskRunAttempt)flowableAttempts.getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/sequential-with-local-errors.yaml")
    void sequentialWithLocalErrors(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/sequential-with-disabled.yaml")
    void sequentialWithDisabled(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
    }
}

