/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.IdUtils;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class StateTest {
    public static final String FLOW_ID = "state";
    public static final String NAMESPACE = "io.kestra.tests";
    @Inject
    private TestRunnerUtils runnerUtils;

    StateTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/state.yaml"})
    void set() throws TimeoutException, QueueException {
        String stateName = IdUtils.create();
        Execution execution = this.runnerUtils.runOne("main", NAMESPACE, FLOW_ID, null, (f, e) -> ImmutableMap.of((Object)FLOW_ID, (Object)stateName));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Integer)((Integer)((Map)((TaskRun)execution.findTaskRunsByTaskId("createGet").getFirst()).getOutputs().get((Object)"data")).get("value"))).isEqualTo(1);
        execution = this.runnerUtils.runOne("main", NAMESPACE, FLOW_ID, null, (f, e) -> ImmutableMap.of((Object)FLOW_ID, (Object)stateName));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat(((Map)((TaskRun)execution.findTaskRunsByTaskId("updateGet").getFirst()).getOutputs().get((Object)"data")).get("value")).isEqualTo((Object)"2");
        execution = this.runnerUtils.runOne("main", NAMESPACE, FLOW_ID, null, (f, e) -> ImmutableMap.of((Object)FLOW_ID, (Object)stateName));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(5);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((Integer)((Integer)((TaskRun)execution.findTaskRunsByTaskId("deleteGet").getFirst()).getOutputs().get((Object)"count"))).isZero();
    }

    @Test
    @LoadFlows(value={"flows/valids/state.yaml"}, tenantId="tenant1")
    void each() throws TimeoutException, InternalException, QueueException {
        Execution execution = this.runnerUtils.runOne("tenant1", NAMESPACE, FLOW_ID, null, (f, e) -> ImmutableMap.of((Object)FLOW_ID, (Object)"each"));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(19);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((String)((String)((Map)execution.findTaskRunByTaskIdAndValue("regetEach1", List.of("b")).getOutputs().get((Object)"data")).get("value"))).isEqualTo("null-b");
        Assertions.assertThat((String)((String)((Map)execution.findTaskRunByTaskIdAndValue("regetEach2", List.of("b")).getOutputs().get((Object)"data")).get("value"))).isEqualTo("null-a-b");
    }
}

