/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.ExecutionRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class SubflowRunnerTest {
    @Inject
    private TestRunnerUtils runnerUtils;
    @Inject
    private ExecutionRepositoryInterface executionRepository;
    @Inject
    @Named(value="executionQueue")
    protected QueueInterface<Execution> executionQueue;

    SubflowRunnerTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/subflow-inherited-labels-child.yaml", "flows/valids/subflow-inherited-labels-parent.yaml"})
    void inheritedLabelsAreOverridden() throws QueueException, TimeoutException {
        Execution parentExecution = this.runnerUtils.runOne("main", "io.kestra.tests", "subflow-inherited-labels-parent");
        Assertions.assertThat((List)parentExecution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", parentExecution.getId()), new Label("parentFlowLabel1", "value1"), new Label("parentFlowLabel2", "value2")});
        String childExecutionId = (String)((TaskRun)parentExecution.findTaskRunsByTaskId("launch").getFirst()).getOutputs().get((Object)"executionId");
        Assertions.assertThat((String)childExecutionId).isNotBlank();
        Execution childExecution = (Execution)this.executionRepository.findById("main", childExecutionId).orElseThrow();
        Assertions.assertThat((List)childExecution.getLabels()).containsExactlyInAnyOrder((Object[])new Label[]{new Label("system.correlationId", parentExecution.getId()), new Label("childFlowLabel1", "value1"), new Label("childFlowLabel2", "value2"), new Label("launchTaskLabel", "launchFoo"), new Label("parentFlowLabel1", "launchBar"), new Label("parentFlowLabel2", "value2")});
    }

    @Test
    @LoadFlows(value={"flows/valids/subflow-parent-no-wait.yaml", "flows/valids/subflow-child-with-output.yaml"})
    void subflowOutputWithoutWait() throws QueueException, TimeoutException, InterruptedException {
        AtomicReference childExecution = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable closing = this.executionQueue.receive(either -> {
            if (either.isLeft() && ((Execution)either.getLeft()).getFlowId().equals("subflow-child-with-output") && ((Execution)either.getLeft()).getState().isTerminated()) {
                childExecution.set((Execution)either.getLeft());
                countDownLatch.countDown();
            }
        });
        Execution parentExecution = this.runnerUtils.runOne("main", "io.kestra.tests", "subflow-parent-no-wait");
        String childExecutionId = (String)((TaskRun)parentExecution.findTaskRunsByTaskId("subflow").getFirst()).getOutputs().get((Object)"executionId");
        Assertions.assertThat((String)childExecutionId).isNotBlank();
        Assertions.assertThat((Comparable)parentExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)parentExecution.getTaskRunList()).hasSize(1);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertThat((String)((Execution)childExecution.get()).getId()).isEqualTo(childExecutionId);
        Assertions.assertThat((Comparable)((Execution)childExecution.get()).getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)((Execution)childExecution.get()).getTaskRunList()).hasSize(1);
        closing.run();
    }

    @Test
    @LoadFlows(value={"flows/valids/subflow-parent-retry.yaml", "flows/valids/subflow-to-retry.yaml"})
    void subflowOutputWithWait() throws QueueException, TimeoutException, InterruptedException {
        ArrayList childExecution = new ArrayList();
        CountDownLatch countDownLatch = new CountDownLatch(4);
        Runnable closing = this.executionQueue.receive(either -> {
            if (either.isLeft() && ((Execution)either.getLeft()).getFlowId().equals("subflow-to-retry") && ((Execution)either.getLeft()).getState().isTerminated()) {
                childExecution.add((Execution)either.getLeft());
                countDownLatch.countDown();
            }
        });
        Execution parentExecution = this.runnerUtils.runOne("main", "io.kestra.tests", "subflow-parent-retry");
        Assertions.assertThat((Comparable)parentExecution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        Assertions.assertThat((List)parentExecution.getTaskRunList()).hasSize(5);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)countDownLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertThat(childExecution).hasSize(4);
        Assertions.assertThat((long)childExecution.stream().filter(e -> e.getState().getCurrent() == State.Type.SUCCESS).count()).isEqualTo(2L);
        Assertions.assertThat((long)childExecution.stream().filter(e -> e.getState().getCurrent() == State.Type.FAILED).count()).isEqualTo(2L);
        closing.run();
    }
}

