/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.flows.State;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.services.VariablesService;
import io.kestra.plugin.core.flow.Subflow;
import io.micronaut.context.ApplicationContext;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class SubflowTest {
    private static final Logger LOG = LoggerFactory.getLogger(SubflowTest.class);
    private static final State DEFAULT_SUCCESS_STATE = State.of((State.Type)State.Type.SUCCESS, List.of(new State.History(State.Type.CREATED, Instant.now()), new State.History(State.Type.RUNNING, Instant.now()), new State.History(State.Type.SUCCESS, Instant.now())));
    public static final String EXECUTION_ID = "executionId";
    @Mock
    private DefaultRunContext runContext;
    @Mock
    private ApplicationContext applicationContext;

    SubflowTest() {
    }

    @BeforeEach
    void beforeEach() {
        Mockito.when((Object)((VariablesService)this.applicationContext.getBean(VariablesService.class))).thenReturn((Object)new VariablesService());
        Mockito.when((Object)this.runContext.logger()).thenReturn((Object)LOG);
        Mockito.when((Object)this.runContext.getApplicationContext()).thenReturn((Object)this.applicationContext);
    }

    @Test
    void shouldNotReturnResultForExecutionNotTerminated() {
        TaskRun taskRun = TaskRun.builder().state(State.of((State.Type)State.Type.CREATED, Collections.emptyList())).build();
        Optional result = new Subflow().createSubflowExecutionResult((RunContext)this.runContext, taskRun, (FlowInterface)Flow.builder().build(), Execution.builder().build());
        Assertions.assertThat((Optional)result).isEmpty();
    }

    @Test
    void shouldNotReturnOutputsForSubflowOutputsDisabled() {
        Mockito.when((Object)this.applicationContext.getProperty("outputs.enabled", Boolean.class)).thenReturn(Optional.of(false));
        Map<String, String> outputs = Map.of("key", "value");
        Subflow subflow = Subflow.builder().outputs(outputs).build();
        Optional result = subflow.createSubflowExecutionResult((RunContext)this.runContext, TaskRun.builder().state(DEFAULT_SUCCESS_STATE).namespace("io.kestra.test").flowId("flow").executionId("execution").taskId("task").id("id").build(), (FlowInterface)Flow.builder().build(), Execution.builder().id(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isPresent());
        Map expected = Subflow.Output.builder().executionId(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE.getCurrent()).outputs(Collections.emptyMap()).build().toMap();
        Assertions.assertThat((Map)((SubflowExecutionResult)result.get()).getParentTaskRun().getOutputs()).containsAllEntriesOf(expected);
        Assertions.assertThat((List)((TaskRunAttempt)((SubflowExecutionResult)result.get()).getParentTaskRun().getAttempts().getFirst()).getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    void shouldReturnOutputsForSubflowOutputsEnabled() throws IllegalVariableEvaluationException {
        Mockito.when((Object)this.applicationContext.getProperty("outputs.enabled", Boolean.class)).thenReturn(Optional.of(true));
        Map<String, String> outputs = Map.of("key", "value");
        Mockito.when((Object)this.runContext.render(Mockito.anyMap())).thenReturn(outputs);
        Subflow subflow = Subflow.builder().outputs(outputs).build();
        Optional result = subflow.createSubflowExecutionResult((RunContext)this.runContext, TaskRun.builder().state(DEFAULT_SUCCESS_STATE).namespace("io.kestra.test").flowId("flow").executionId("execution").taskId("task").id("id").build(), (FlowInterface)Flow.builder().build(), Execution.builder().id(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isPresent());
        Map expected = Subflow.Output.builder().executionId(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE.getCurrent()).outputs(outputs).build().toMap();
        Assertions.assertThat((Map)((SubflowExecutionResult)result.get()).getParentTaskRun().getOutputs()).containsAllEntriesOf(expected);
        Assertions.assertThat((List)((TaskRunAttempt)((SubflowExecutionResult)result.get()).getParentTaskRun().getAttempts().get(0)).getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }

    @Test
    void shouldOnlyReturnOutputsFromFlowOutputs() throws IllegalVariableEvaluationException {
        Mockito.when((Object)this.applicationContext.getProperty("outputs.enabled", Boolean.class)).thenReturn(Optional.of(true));
        Output output = Output.builder().id("key").value((Object)"value").build();
        Mockito.when((Object)this.runContext.render(Mockito.anyMap())).thenReturn(Map.of(output.getId(), output.getValue()));
        Flow flow = Flow.builder().outputs(List.of(output)).build();
        Optional result = new Subflow().createSubflowExecutionResult((RunContext)this.runContext, TaskRun.builder().state(DEFAULT_SUCCESS_STATE).namespace("io.kestra.test").flowId("flow").executionId("execution").taskId("task").id("id").build(), (FlowInterface)flow, Execution.builder().id(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE).build());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)result.isPresent());
        Variables outputs = ((SubflowExecutionResult)result.get()).getParentTaskRun().getOutputs();
        Map expected = Subflow.Output.builder().executionId(EXECUTION_ID).state(DEFAULT_SUCCESS_STATE.getCurrent()).outputs(Map.of(output.getId(), output.getValue())).build().toMap();
        Assertions.assertThat((Map)outputs).containsAllEntriesOf(expected);
        Assertions.assertThat((List)((TaskRunAttempt)((SubflowExecutionResult)result.get()).getParentTaskRun().getAttempts().getFirst()).getState().getHistories()).extracting(State.History::getState).containsExactly((Object[])new State.Type[]{State.Type.CREATED, State.Type.RUNNING, State.Type.SUCCESS});
    }
}

