/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.TestRunnerUtils;
import jakarta.inject.Inject;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
class SwitchTest {
    @Inject
    private TestRunnerUtils runnerUtils;

    SwitchTest() {
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml"}, tenantId="switch")
    void switchFirst() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("switch", "io.kestra.tests", "switch", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"FIRST"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("t1");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"FIRST");
        Assertions.assertThat((Boolean)((Boolean)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"defaults"))).isEqualTo(false);
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml"}, tenantId="second")
    void switchSecond() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("second", "io.kestra.tests", "switch", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"SECOND"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("t2");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"SECOND");
        Assertions.assertThat((Boolean)((Boolean)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"defaults"))).isFalse();
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("t2_sub");
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml"}, tenantId="third")
    void switchThird() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("third", "io.kestra.tests", "switch", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"THIRD"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("t3");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"THIRD");
        Assertions.assertThat((Boolean)((Boolean)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"defaults"))).isFalse();
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(2)).getTaskId()).isEqualTo("failed");
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(3)).getTaskId()).isEqualTo("error-t1");
    }

    @Test
    @LoadFlows(value={"flows/valids/switch.yaml"})
    void switchDefault() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "switch", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"DEFAULT"));
        Assertions.assertThat((String)((TaskRun)execution.getTaskRunList().get(1)).getTaskId()).isEqualTo("default");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"DEFAULT");
        Assertions.assertThat((Boolean)((Boolean)((TaskRun)execution.findTaskRunsByTaskId("parent-seq").getFirst()).getOutputs().get((Object)"defaults"))).isTrue();
    }

    @Test
    @LoadFlows(value={"flows/valids/switch-impossible.yaml"})
    void switchImpossible() throws TimeoutException, QueueException {
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "switch-impossible", null, (f, e) -> ImmutableMap.of((Object)"string", (Object)"impossible"));
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

