/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.templates.Template;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.TemplateRepositoryInterface;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.log.Log;
import io.micronaut.context.annotation.Property;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
@Property(name="kestra.templates.enabled", value="true")
public class TemplateTest {
    @Inject
    protected TemplateRepositoryInterface templateRepository;
    @Inject
    @Named(value="workerTaskLogQueue")
    protected QueueInterface<LogEntry> logQueue;
    @Inject
    private FlowInputOutput flowIO;
    @Inject
    protected TestRunnerUtils runnerUtils;
    public static final Template TEMPLATE_1 = Template.builder().id("template").namespace("io.kestra.tests").tenantId("main").tasks(Collections.singletonList(((Log.LogBuilder)((Log.LogBuilder)Log.builder().id("test")).type(Log.class.getName())).message((Object)"{{ parent.outputs.args['my-forward'] }}").build())).build();

    public static void withTemplate(TestRunnerUtils runnerUtils, TemplateRepositoryInterface templateRepository, QueueInterface<LogEntry> logQueue, FlowInputOutput flowIO) throws TimeoutException, QueueException {
        templateRepository.create(TEMPLATE_1);
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "with-template", null, (flow, execution1) -> flowIO.readExecutionInputs(flow, execution1, (Map)ImmutableMap.of((Object)"with-string", (Object)"myString", (Object)"with-optional", (Object)"myOpt")), Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        receive.blockLast();
    }

    @Test
    @LoadFlows(value={"flows/templates/with-template.yaml"})
    void withTemplate() throws TimeoutException, QueueException {
        TemplateTest.withTemplate(this.runnerUtils, this.templateRepository, this.logQueue, this.flowIO);
    }

    public static void withFailedTemplate(TestRunnerUtils runnerUtils, QueueInterface<LogEntry> logQueue) throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(logQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "with-failed-template", Duration.ofSeconds(60L));
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, logEntry -> logEntry.getMessage().endsWith("Can't find flow template 'io.kestra.tests.invalid'") && logEntry.getLevel() == Level.ERROR);
        receive.blockLast();
        Assertions.assertThat((Object)matchingLog).isNotNull();
    }

    @Test
    @LoadFlows(value={"flows/templates/with-failed-template.yaml"})
    void withFailedTemplate() throws TimeoutException, QueueException {
        TemplateTest.withFailedTemplate(this.runnerUtils, this.logQueue);
    }
}

