/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.flow.Sleep;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junitpioneer.jupiter.RetryingTest;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
class TimeoutTest {
    @Inject
    FlowRepositoryInterface flowRepository;
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> workerTaskLogQueue;
    @Inject
    private TestRunnerUtils runnerUtils;

    TimeoutTest() {
    }

    @RetryingTest(value=5)
    void timeout() throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Flow flow = ((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().id(IdUtils.create())).namespace("io.kestra.unittest")).revision(Integer.valueOf(1))).tasks(Collections.singletonList(((Sleep.SleepBuilder)((Sleep.SleepBuilder)((Sleep.SleepBuilder)Sleep.builder().id("test")).type(Sleep.class.getName())).duration(Property.ofValue((Object)Duration.ofSeconds(100L))).timeout(Property.ofValue((Object)Duration.ofNanos(100000L)))).build())).build();
        this.flowRepository.create(GenericFlow.of((FlowInterface)flow));
        Execution execution = this.runnerUtils.runOne(flow.getTenantId(), flow.getNamespace(), flow.getId());
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        List matchingLogs = TestsUtils.awaitLogs(logs, logEntry -> logEntry.getMessage().contains("Timeout"), (Integer)2);
        receive.blockLast();
        Assertions.assertThat((int)matchingLogs.size()).isEqualTo(2);
    }
}

