/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import io.kestra.core.junit.annotations.ExecuteFlow;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.utils.TestsUtils;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;
import reactor.core.publisher.Flux;

@KestraTest(startRunner=true)
class VariablesTest {
    @Inject
    @Named(value="workerTaskLogQueue")
    QueueInterface<LogEntry> workerTaskLogQueue;
    @Inject
    private TestRunnerUtils runnerUtils;

    VariablesTest() {
    }

    @Test
    @ExecuteFlow(value="flows/valids/variables.yaml")
    @EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="ENV_TEST1", matches=".*"), @EnabledIfEnvironmentVariable(named="ENV_TEST2", matches=".*")})
    void recursiveVars(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("variable").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"1 > 2 > 3");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("env").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"true Pass by env");
        Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("global").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"string 1 true 2");
    }

    @Test
    @LoadFlows(value={"flows/valids/variables-invalid.yaml"})
    void invalidVars() throws TimeoutException, QueueException {
        CopyOnWriteArrayList logs = new CopyOnWriteArrayList();
        Flux receive = TestsUtils.receive(this.workerTaskLogQueue, either -> logs.add((LogEntry)either.getLeft()));
        Execution execution = this.runnerUtils.runOne("main", "io.kestra.tests", "variables-invalid");
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().get(1)).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        LogEntry matchingLog = TestsUtils.awaitLog(logs, logEntry -> Objects.equals(logEntry.getTaskRunId(), ((TaskRun)execution.getTaskRunList().get(1)).getId()) && logEntry.getMessage().contains("Unable to find `inputs` used in the expression `{{inputs.invalid}}`"));
        receive.blockLast();
        Assertions.assertThat((Object)matchingLog).isNotNull();
        Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }

    @Test
    @ExecuteFlow(value="flows/valids/failed-first.yaml")
    void failedFirst(Execution execution) {
        Assertions.assertThat((List)execution.getTaskRunList()).hasSize(1);
        Assertions.assertThat((Comparable)((TaskRun)execution.getTaskRunList().getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
    }
}

