/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.junit.annotations.FlakyTest;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.junit.annotations.LoadFlows;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.TestRunnerUtils;
import io.kestra.core.storages.InternalStorage;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

@KestraTest(startRunner=true)
public class WorkingDirectoryTest {
    @Inject
    Suite suite;
    @Inject
    RunContextFactory runContextFactory;
    @Inject
    TestRunnerUtils runnerUtils;

    @Test
    @LoadFlows(value={"flows/valids/working-directory.yaml"})
    void success() throws TimeoutException, QueueException {
        this.suite.success(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory.yaml"}, tenantId="tenant1")
    void failed() throws TimeoutException, QueueException {
        this.suite.failed("tenant1", this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-each.yaml"})
    void each() throws TimeoutException, QueueException {
        this.suite.each(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-cache.yml"})
    void cache() throws TimeoutException, IOException, QueueException {
        this.suite.cache(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-taskrun.yml"})
    void taskrun() throws TimeoutException, InternalException, QueueException {
        this.suite.taskRun(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-taskrun-nested.yml"})
    void taskrunNested() throws TimeoutException, InternalException, QueueException {
        this.suite.taskRunNested(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-namespace-files.yaml"})
    void namespaceFiles() throws TimeoutException, IOException, QueueException {
        this.suite.namespaceFiles(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-namespace-files-with-namespaces.yaml"})
    void namespaceFilesWithNamespace() throws TimeoutException, IOException, QueueException {
        this.suite.namespaceFilesWithNamespaces(this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-inputs.yml"})
    void inputFiles() throws Exception {
        this.suite.inputFiles(this.runnerUtils);
    }

    @FlakyTest
    @LoadFlows(value={"flows/valids/working-directory-outputs.yml"}, tenantId="output")
    void outputFiles() throws Exception {
        this.suite.outputFiles("output", this.runnerUtils);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-taskrun-encrypted.yml"})
    void encryption() throws Exception {
        this.suite.encryption(this.runnerUtils, this.runContextFactory);
    }

    @Test
    @LoadFlows(value={"flows/valids/working-directory-invalid-runif.yaml"})
    void invalidRunIf() throws Exception {
        this.suite.invalidRunIf(this.runnerUtils);
    }

    @Singleton
    public static class Suite {
        @Inject
        StorageInterface storageInterface;

        public void success(TestRunnerUtils runnerUtils) throws TimeoutException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"false"), Duration.ofSeconds(60L));
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(4);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((String)((String)((TaskRun)execution.getTaskRunList().get(3)).getOutputs().get((Object)"value"))).startsWith((CharSequence)"kestra://");
        }

        public void failed(String tenantId, TestRunnerUtils runnerUtils) throws TimeoutException, QueueException {
            Execution execution = runnerUtils.runOne(tenantId, "io.kestra.tests", "working-directory", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"true"), Duration.ofSeconds(60L));
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
            Assertions.assertThat((List)execution.findTaskRunsByTaskId("error-t1")).hasSize(1);
        }

        public void each(TestRunnerUtils runnerUtils) throws TimeoutException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-each", Duration.ofSeconds(60L));
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(8);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((String)((String)((TaskRun)execution.findTaskRunsByTaskId("2_end").getFirst()).getOutputs().get((Object)"value"))).startsWith((CharSequence)"kestra://");
        }

        public void outputFiles(String tenantId, TestRunnerUtils runnerUtils) throws TimeoutException, IOException, QueueException {
            Execution execution = runnerUtils.runOne(tenantId, "io.kestra.tests", "working-directory-outputs");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            TaskRun taskRun = (TaskRun)execution.getTaskRunList().getFirst();
            Variables outputs = taskRun.getOutputs();
            Assertions.assertThat((Map)outputs).containsKey((Object)"outputFiles");
            StorageContext storageContext = StorageContext.forTask((TaskRun)taskRun);
            InternalStorage storage = new InternalStorage(null, storageContext, this.storageInterface, null);
            URI uri = ((Map)outputs.get("outputFiles")).values().stream().map(URI::create).toList().getFirst();
            Assertions.assertThat((String)new String(storage.getFile(uri).readAllBytes())).isEqualTo("Hello World");
        }

        public void inputFiles(TestRunnerUtils runnerUtils) throws TimeoutException, IOException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-inputs");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            StorageContext storageContext = StorageContext.forTask((TaskRun)((TaskRun)execution.getTaskRunList().get(1)));
            InternalStorage storage = new InternalStorage(null, storageContext, this.storageInterface, null);
            TaskRun taskRun = (TaskRun)execution.getTaskRunList().get(1);
            Variables outputs = taskRun.getOutputs();
            Assertions.assertThat((Map)outputs).containsKey((Object)"uris");
            URI uri = URI.create((String)((Map)outputs.get("uris")).get("input.txt"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)uri.toString().endsWith("input.txt"));
            Assertions.assertThat((String)new String(storage.getFile(uri).readAllBytes())).isEqualTo("Hello World");
        }

        public void cache(TestRunnerUtils runnerUtils) throws TimeoutException, IOException, QueueException {
            StorageContext storageContext = StorageContext.forFlow((FlowId)((Flow.FlowBuilder)((Flow.FlowBuilder)((Flow.FlowBuilder)Flow.builder().namespace("io.kestra.tests")).id("working-directory-cache")).tenantId("main")).build());
            InternalStorage storage = new InternalStorage(null, storageContext, this.storageInterface, null);
            storage.deleteCacheFile("workingDir", null);
            URI cacheURI = storageContext.getCacheURI("workingdir", null);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.storageInterface.exists("main", null, cacheURI));
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-cache");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
            Assertions.assertThat((Map)execution.getTaskRunList().stream().filter(t -> t.getTaskId().equals("exists")).findFirst().get().getOutputs()).containsAllEntriesOf(Map.of("uris", Collections.emptyMap()));
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storageInterface.exists("main", null, cacheURI));
            execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-cache");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
            Assertions.assertThat((boolean)((Map)execution.getTaskRunList().stream().filter(t -> t.getTaskId().equals("exists")).findFirst().get().getOutputs().get((Object)"uris")).containsKey("hello.txt")).isTrue();
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
        }

        public void taskRun(TestRunnerUtils runnerUtils) throws TimeoutException, InternalException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-taskrun");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((String)((String)execution.findTaskRunByTaskIdAndValue("log-taskrun", List.of("1")).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"1"});
        }

        public void taskRunNested(TestRunnerUtils runnerUtils) throws TimeoutException, InternalException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-taskrun-nested");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.SUCCESS);
            Assertions.assertThat((String)((String)execution.findTaskRunByTaskIdAndValue("log-workerparent", List.of("1")).getOutputs().get((Object)"value"))).contains(new CharSequence[]{"{\"taskrun\":{\"value\":\"1\"}}"});
        }

        public void namespaceFiles(TestRunnerUtils runnerUtils) throws TimeoutException, IOException, QueueException {
            this.put("/test/a/b/c/1.txt", "first");
            this.put("/a/b/c/2.txt", "second");
            this.put("/a/b/3.txt", "third");
            this.put("/ignore/4.txt", "4th");
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-namespace-files");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
            Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("t4").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t1").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"first");
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t2").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"second");
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t3").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"third");
        }

        public void namespaceFilesWithNamespaces(TestRunnerUtils runnerUtils) throws TimeoutException, IOException, QueueException {
            this.put("/test/a/b/c/1.txt", "first in first namespace", "io.test.first");
            this.put("/a/b/c/2.txt", "second in first namespace", "io.test.first");
            this.put("/a/b/3.txt", "third in first namespace", "io.test.first");
            this.put("/ignore/4.txt", "4th");
            this.put("/test/a/b/c/1.txt", "first in second namespace", "io.test.second");
            this.put("/a/b/c/2.txt", "second in second namespace", "io.test.second");
            this.put("/test/a/b/c/1.txt", "first in third namespace", "io.test.third");
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-namespace-files-with-namespaces");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(6);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.WARNING);
            Assertions.assertThat((Comparable)((TaskRun)execution.findTaskRunsByTaskId("t4").getFirst()).getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t1").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"first in third namespace");
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t2").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"second in second namespace");
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("t3").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"third in first namespace");
        }

        public void encryption(TestRunnerUtils runnerUtils, RunContextFactory runContextFactory) throws TimeoutException, GeneralSecurityException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-taskrun-encrypted");
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(3);
            Map encryptedString = (Map)((TaskRun)execution.findTaskRunsByTaskId("encrypted").getFirst()).getOutputs().get((Object)"value");
            Assertions.assertThat(encryptedString.get("type")).isEqualTo((Object)"io.kestra.datatype:aes_encrypted");
            String encryptedValue = (String)encryptedString.get("value");
            Assertions.assertThat((String)encryptedValue).isNotEqualTo((Object)"Hello World");
            Assertions.assertThat((String)runContextFactory.of().decrypt(encryptedValue)).isEqualTo("Hello World");
            Assertions.assertThat((Object)((TaskRun)execution.findTaskRunsByTaskId("decrypted").getFirst()).getOutputs().get((Object)"value")).isEqualTo((Object)"Hello World");
        }

        public void invalidRunIf(TestRunnerUtils runnerUtils) throws TimeoutException, QueueException {
            Execution execution = runnerUtils.runOne("main", "io.kestra.tests", "working-directory-invalid-runif", null, (f, e) -> ImmutableMap.of((Object)"failed", (Object)"false"), Duration.ofSeconds(60L));
            Assertions.assertThat((List)execution.getTaskRunList()).hasSize(2);
            Assertions.assertThat((Comparable)execution.getState().getCurrent()).isEqualTo((Object)State.Type.FAILED);
        }

        private void put(String path, String content) throws IOException {
            this.put(path, content, "io.kestra.tests");
        }

        private void put(String path, String content, String namespace) throws IOException {
            this.storageInterface.put("main", null, URI.create(StorageContext.namespaceFilePrefix((String)namespace) + path), (InputStream)new ByteArrayInputStream(content.getBytes()));
        }
    }
}

