/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.http.client.HttpClientResponseException;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.http.Download;
import io.micronaut.context.ApplicationContext;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@KestraTest
class DownloadTest {
    public static final String FILE = "https://sampletestfile.com/wp-content/uploads/2023/07/500KB-CSV.csv";
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private StorageInterface storageInterface;
    @Inject
    private ApplicationContext applicationContext;

    DownloadTest() {
    }

    @Test
    void run() throws Exception {
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)FILE))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.storageInterface.get("main", null, output.getUri()), (Charset)StandardCharsets.UTF_8)).isEqualTo(IOUtils.toString((InputStream)new URI(FILE).toURL().openStream(), (Charset)StandardCharsets.UTF_8));
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)".csv");
    }

    @Test
    void noResponse() {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/204")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        HttpClientResponseException exception = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> task.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("No response from server");
    }

    @Test
    void allowNoResponse() throws IOException {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).failOnEmptyResponse(Property.ofValue((Object)false)).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/204")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = (Download.Output)org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> task.run(runContext));
        Assertions.assertThat((Long)output.getLength()).isEqualTo(0L);
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.storageInterface.get("main", null, output.getUri()), (Charset)StandardCharsets.UTF_8)).isEqualTo("");
    }

    @Test
    void error() {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/500")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        HttpClientResponseException exception = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> task.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Failed http request with response code '500'"});
    }

    @Test
    void chunked() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/chunked")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((int)this.storageInterface.get("main", null, output.getUri()).readAllBytes().length).isEqualTo(120000);
    }

    @Test
    void contentDisposition() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/content-disposition")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)"filename.jpg");
    }

    @Test
    void fileNameShouldOverrideContentDisposition() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/content-disposition")))).saveAs(Property.ofValue((Object)"hardcoded-filename.jpg")).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)"hardcoded-filename.jpg");
    }

    @Test
    void contentDispositionWithPath() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/content-disposition")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)output.getUri().toString()).doesNotContain(new CharSequence[]{"/secure-path/"});
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)"filename.jpg");
    }

    @Test
    void failed() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(Download.class.getSimpleName())).type(Download.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello417")))).options(HttpConfiguration.builder().allowFailed(Property.ofValue((Object)true)).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Download.Output output = task.run(runContext);
            Assertions.assertThat((List)((List)output.getHeaders().get("content-type"))).isEqualTo(List.of("application/json"));
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(417);
        }
    }

    @Test
    void contentDispositionWithDoubleDot() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/content-disposition-double-dot")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)output.getUri().toString()).doesNotContain(new CharSequence[]{"/secure-path/"});
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)"filename..jpg");
    }

    @Test
    void contentDispositionWithSpaceAfterDot() throws Exception {
        EmbeddedServer embeddedServer = (EmbeddedServer)this.applicationContext.getBean(EmbeddedServer.class);
        embeddedServer.start();
        Download task = ((Download.DownloadBuilder)((Download.DownloadBuilder)((Download.DownloadBuilder)Download.builder().id(DownloadTest.class.getSimpleName())).type(DownloadTest.class.getName())).uri(Property.ofValue((Object)(String.valueOf(embeddedServer.getURI()) + "/content-disposition-space-after-dot")))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Download.Output output = task.run(runContext);
        Assertions.assertThat((String)output.getUri().toString()).doesNotContain(new CharSequence[]{"/secure-path/"});
        Assertions.assertThat((String)output.getUri().toString()).endsWith((CharSequence)"file.with+spaces.txt");
    }

    @Controller
    public static class SlackWebController {
        @Get(value="500")
        public HttpResponse<String> error() {
            return HttpResponse.serverError();
        }

        @Get(value="204")
        public HttpResponse<Void> noContent() {
            return HttpResponse.noContent();
        }

        @Get(value="chunked")
        public Flux<byte[]> chunked() {
            return Flux.create(sink -> {
                for (int i = 0; i < 10000; ++i) {
                    sink.next((Object)"Hello World\n".getBytes());
                }
                sink.complete();
            }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
        }

        @Get(value="content-disposition")
        public HttpResponse<byte[]> contentDisposition() {
            return HttpResponse.ok((Object)"Hello World".getBytes()).header((CharSequence)"Content-Disposition", (CharSequence)"attachment; filename=\"filename.jpg\"");
        }

        @Get(value="content-disposition-path")
        public HttpResponse<byte[]> contentDispositionWithPath() {
            return HttpResponse.ok((Object)"Hello World".getBytes()).header((CharSequence)"Content-Disposition", (CharSequence)"attachment; filename=\"/secure-path/filename.jpg\"");
        }

        @Get(value="content-disposition-double-dot")
        public HttpResponse<byte[]> contentDispositionWithDoubleDot() {
            return HttpResponse.ok((Object)"Hello World".getBytes()).header((CharSequence)"Content-Disposition", (CharSequence)"attachment; filename=\"/secure-path/filename..jpg\"");
        }

        @Get(value="content-disposition-space-after-dot")
        public HttpResponse<byte[]> contentDispositionWithSpaceAfterDot() {
            return HttpResponse.ok((Object)"Hello World".getBytes()).header((CharSequence)"Content-Disposition", (CharSequence)"attachment; filename=\"file.with spaces.txt\"");
        }
    }
}

