/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import com.devskiller.friendly_id.FriendlyId;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.context.TestRunContextFactory;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.client.HttpClientRequestException;
import io.kestra.core.http.client.HttpClientResponseException;
import io.kestra.core.http.client.configurations.AbstractAuthConfiguration;
import io.kestra.core.http.client.configurations.BasicAuthConfiguration;
import io.kestra.core.http.client.configurations.BearerAuthConfiguration;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.http.client.configurations.SslOptions;
import io.kestra.core.http.client.configurations.TimeoutConfiguration;
import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.TestsUtils;
import io.kestra.plugin.core.http.Request;
import io.micronaut.context.ApplicationContext;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.multipart.StreamingFileUpload;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@KestraTest
@Execution(value=ExecutionMode.SAME_THREAD)
class RequestTest {
    @Inject
    private TestRunContextFactory runContextFactory;
    @Inject
    private StorageInterface storageInterface;

    RequestTest() {
    }

    @Test
    void run() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{ \"hello\": \"world\" }");
            Assertions.assertThat((Object)output.getEncryptedBody()).isNull();
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void head() throws Exception {
        String url = "https://sampletestfile.com/wp-content/uploads/2023/07/500KB-CSV.csv";
        Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)"https://sampletestfile.com/wp-content/uploads/2023/07/500KB-CSV.csv"))).method(Property.ofValue((Object)"HEAD"))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        Request.Output output = task.run(runContext);
        Assertions.assertThat((URI)output.getUri()).isEqualTo((Object)URI.create("https://sampletestfile.com/wp-content/uploads/2023/07/500KB-CSV.csv"));
        Assertions.assertThat((String)((String)((List)output.getHeaders().get("content-length")).getFirst())).isEqualTo("512789");
    }

    @Test
    void head404() throws Exception {
        String url = "https://bdnb-data.s3.fr-par.scw.cloud/bnb_export_metropole_sql_dump.tar.gz";
        Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)"https://bdnb-data.s3.fr-par.scw.cloud/bnb_export_metropole_sql_dump.tar.gz"))).method(Property.ofValue((Object)"HEAD"))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        HttpClientResponseException exception = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> task.run(runContext));
        Assertions.assertThat((int)exception.getResponse().getStatus().getCode()).isEqualTo(404);
    }

    @Test
    void redirect() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/redirect")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{ \"hello\": \"world\" }");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void params() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/params?foo=baz")))).params(Property.ofValue(Map.of("hello", "world", "foo", "bar", "bar", List.of("foo1", "foo2"))))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((String)((String)output.getBody())).contains(new CharSequence[]{"hello=world"});
            Assertions.assertThat((String)((String)output.getBody())).contains(new CharSequence[]{"foo=baz"});
            Assertions.assertThat((String)((String)output.getBody())).contains(new CharSequence[]{"foo=bar"});
            Assertions.assertThat((String)((String)output.getBody())).contains(new CharSequence[]{"bar=foo1"});
            Assertions.assertThat((String)((String)output.getBody())).contains(new CharSequence[]{"bar=foo2"});
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void noRedirect() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/redirect")))).options(HttpConfiguration.builder().followRedirects(Property.ofValue((Object)false)).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(301);
        }
    }

    @Test
    void allowFailed() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello417")))).options(HttpConfiguration.builder().allowFailed(Property.ofValue((Object)true)).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{ \"hello\": \"world\" }");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(417);
        }
    }

    @Test
    void failed() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello417")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            HttpClientResponseException exception = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> task.run(runContext));
            Assertions.assertThat((int)exception.getResponse().getStatus().getCode()).isEqualTo(417);
        }
    }

    @Test
    void failedPost() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/markdown")))).method(Property.ofValue((Object)"POST"))).body(Property.ofValue((Object)"# hello web!"))).contentType(Property.ofValue((Object)"text/markdown"))).options(HttpConfiguration.builder().defaultCharset(Property.ofValue(null)).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            HttpClientResponseException exception = (HttpClientResponseException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientResponseException.class, () -> task.run(runContext));
            Assertions.assertThat((int)exception.getResponse().getStatus().getCode()).isEqualTo(417);
            Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"hello world"});
            byte[] content = ((HttpRequest.ByteArrayRequestBody)exception.getRequest().getBody()).getContent();
            Assertions.assertThat((String)new String(content)).contains(new CharSequence[]{"hello web"});
        }
    }

    @Test
    void selfSigned() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run((String[])new String[]{"test", "testssl"});
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello")))).options(HttpConfiguration.builder().timeout(TimeoutConfiguration.builder().readIdleTimeout(Property.ofValue((Object)Duration.ofSeconds(30L))).build()).ssl(SslOptions.builder().insecureTrustAllCertificates(Property.ofValue((Object)true)).build()).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{ \"hello\": \"world\" }");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void selfSignedFailed() {
        try (ApplicationContext applicationContext = ApplicationContext.run((String[])new String[]{"test", "testssl"});
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello")))).options(HttpConfiguration.builder().allowFailed(Property.ofValue((Object)true)).timeout(TimeoutConfiguration.builder().readIdleTimeout(Property.ofValue((Object)Duration.ofSeconds(30L))).build()).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            HttpClientRequestException exception = (HttpClientRequestException)org.junit.jupiter.api.Assertions.assertThrows(HttpClientRequestException.class, () -> task.run(runContext));
            Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"unable to find valid certification path"});
        }
    }

    @Test
    void json() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).method(Property.ofValue((Object)"POST"))).uri(Property.ofValue((Object)(server.getURL().toString() + "/post/json")))).body(Property.ofValue((Object)JacksonMapper.ofJson().writeValueAsString((Object)ImmutableMap.of((Object)"hello", (Object)"world"))))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{\"hello\":\"world\"}");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void form() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).method(Property.ofValue((Object)"POST"))).contentType(Property.ofValue((Object)"application/x-www-form-urlencoded"))).uri(Property.ofValue((Object)(server.getURL().toString() + "/post/url-encoded")))).headers(Property.ofValue(Map.of("test", "{{ inputs.test }}")))).formData(Property.ofValue((Object)ImmutableMap.of((Object)"hello", (Object)"world")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of((Object)"test", (Object)"value"));
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"world > value");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void multipart() throws Exception {
        File file = new File(Objects.requireNonNull(RequestTest.class.getClassLoader().getResource("application-test.yml")).toURI());
        URI fileStorage = this.storageInterface.put("main", null, new URI("/" + FriendlyId.createFriendlyId()), (InputStream)new FileInputStream(file));
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).method(Property.ofValue((Object)"POST"))).contentType(Property.ofValue((Object)"multipart/form-data"))).uri(Property.ofValue((Object)(server.getURL().toString() + "/post/multipart")))).formData(Property.ofValue((Object)ImmutableMap.of((Object)"hello", (Object)"world", (Object)"file", (Object)fileStorage.toString())))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)("world > " + IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8)));
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void multipartCustomFilename() throws Exception {
        File file = new File(Objects.requireNonNull(RequestTest.class.getClassLoader().getResource("application-test.yml")).toURI());
        URI fileStorage = this.storageInterface.put("main", null, new URI("/" + FriendlyId.createFriendlyId()), (InputStream)new FileInputStream(file));
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).method(Property.ofValue((Object)"POST"))).contentType(Property.ofValue((Object)"multipart/form-data"))).uri(Property.ofValue((Object)(server.getURL().toString() + "/post/multipart")))).formData(Property.ofValue((Object)ImmutableMap.of((Object)"hello", (Object)"world", (Object)"file", (Object)ImmutableMap.of((Object)"content", (Object)fileStorage.toString(), (Object)"name", (Object)"test.yml"))))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)("world > " + IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8)));
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void encrypted() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/hello")))).encryptBody(Property.ofValue((Object)true)).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isNull();
            Assertions.assertThat((Object)output.getEncryptedBody()).isNotEqualTo((Object)"{ \"hello\": \"world\" }");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void bytes() {
        Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)"https://github.com/kestra-io.png"))).contentType(Property.ofValue((Object)"application/octet-stream"))).build();
        RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
        IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> task.run(runContext));
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Illegal unicode code"});
    }

    @Test
    void basicAuth() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/auth/basic")))).options(HttpConfiguration.builder().auth((AbstractAuthConfiguration)BasicAuthConfiguration.builder().username(Property.ofValue((Object)"John")).password(Property.ofValue((Object)"p4ss")).build()).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{\"hello\":\"John\"}");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void basicAuthOld() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/auth/basic")))).options(HttpConfiguration.builder().basicAuthUser("John").basicAuthPassword("p4ss").build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"{\"hello\":\"John\"}");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void bearerAuth() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            String id = IdUtils.create();
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/auth/bearer")))).options(HttpConfiguration.builder().auth((AbstractAuthConfiguration)BearerAuthConfiguration.builder().token(Property.ofValue((Object)id)).build()).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, Map.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)("{\"hello\":\"" + id + "\"}"));
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void specialContentType() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/content-type")))).method(Property.ofValue((Object)"POST"))).body(Property.ofValue((Object)"{}"))).contentType(Property.ofValue((Object)"application/vnd.campaignsexport.v1+json"))).options(HttpConfiguration.builder().logs(HttpConfiguration.LoggingType.values()).defaultCharset(null).build())).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"application/vnd.campaignsexport.v1+json");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void spaceInURI() throws Exception {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/uri with space")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            Request.Output output = task.run(runContext);
            Assertions.assertThat((Object)output.getBody()).isEqualTo((Object)"Hello World");
            Assertions.assertThat((Integer)output.getCode()).isEqualTo(200);
        }
    }

    @Test
    void largeBodyFailsFast() {
        try (ApplicationContext applicationContext = ApplicationContext.run();
             EmbeddedServer server = (EmbeddedServer)((EmbeddedServer)applicationContext.getBean(EmbeddedServer.class)).start();){
            Request task = ((Request.RequestBuilder)((Request.RequestBuilder)((Request.RequestBuilder)Request.builder().id(RequestTest.class.getSimpleName())).type(RequestTest.class.getName())).uri(Property.ofValue((Object)(server.getURL().toString() + "/large")))).build();
            RunContext runContext = TestsUtils.mockRunContext((RunContextFactory)this.runContextFactory, (Task)task, (Map)ImmutableMap.of());
            IllegalArgumentException exception = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> task.run(runContext));
            ((AbstractStringAssert)Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"Response body is too large to store in task outputs"})).contains(new CharSequence[]{"Download"});
        }
    }

    @Controller
    static class MockController {
        private static final int LARGE_BODY_SIZE = 0x1400000;
        private static final String LARGE_BODY = "a".repeat(0x1400000);

        MockController() {
        }

        @Get(value="/hello")
        HttpResponse<String> hello() {
            return HttpResponse.ok((Object)"{ \"hello\": \"world\" }");
        }

        @Post(value="content-type")
        @Consumes(value={"application/vnd.campaignsexport.v1+json"})
        @Produces(value={"text/plain"})
        public HttpResponse<String> contentType(HttpRequest<?> request, @Nullable @Body Map<String, String> body) {
            return HttpResponse.ok((Object)((MediaType)request.getContentType().orElseThrow()).toString());
        }

        @Head(value="/hello")
        HttpResponse<String> head() {
            return HttpResponse.ok();
        }

        @Get(value="/hello417")
        HttpResponse<String> hello417() {
            return HttpResponse.status((HttpStatus)HttpStatus.EXPECTATION_FAILED).body((Object)"{ \"hello\": \"world\" }");
        }

        @Get(value="/params")
        HttpResponse<String> params(HttpRequest<?> request) {
            return HttpResponse.ok((Object)request.getUri().getRawQuery());
        }

        @Post(value="/markdown")
        @Consumes(value={"text/markdown"})
        @Produces(value={"text/markdown"})
        HttpResponse<String> postMarkdown() {
            return HttpResponse.status((HttpStatus)HttpStatus.EXPECTATION_FAILED).body((Object)"# hello world");
        }

        @Get(value="/redirect")
        HttpResponse<String> redirect() {
            return HttpResponse.redirect((URI)URI.create("/hello"));
        }

        @Get(value="/auth/basic")
        HttpResponse<String> basicAuth(HttpRequest<?> request) {
            return (HttpResponse)request.getHeaders().getAuthorization().filter(v -> v.startsWith("Basic ")).map(v -> {
                String decode = new String(Base64.getDecoder().decode(v.substring(6).getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
                return decode.split(":", 2);
            }).filter(a -> a[1].equals("p4ss")).map(a -> HttpResponse.ok((Object)("{\"hello\":\"" + a[0] + "\"}"))).orElseThrow();
        }

        @Get(value="/auth/bearer")
        HttpResponse<String> bearerAuth(HttpRequest<?> request) {
            return (HttpResponse)request.getHeaders().getAuthorization().filter(v -> v.startsWith("Bearer ")).map(v -> v.substring(7)).map(a -> HttpResponse.ok((Object)("{\"hello\":\"" + a + "\"}"))).orElseThrow();
        }

        @Post(uri="/post/json")
        HttpResponse<Map<String, String>> postBody(@Body Map<String, String> body) {
            return HttpResponse.ok(body);
        }

        @Post(uri="/post/url-encoded", consumes={"application/x-www-form-urlencoded"})
        HttpResponse<String> postUrlEncoded(HttpRequest<?> request, String hello) {
            return HttpResponse.ok((Object)(hello + " > " + (String)request.getHeaders().get((CharSequence)"test")));
        }

        @Post(uri="/post/multipart", consumes={"multipart/form-data"})
        Mono<String> multipart(HttpRequest<?> request, String hello, StreamingFileUpload file) throws IOException {
            File tempFile = File.createTempFile(file.getFilename(), "temp");
            Publisher uploadPublisher = file.transferTo(tempFile);
            return Mono.from((Publisher)uploadPublisher).map(Rethrow.throwFunction(success -> {
                try (FileInputStream fileInputStream = new FileInputStream(tempFile);){
                    String string = hello + " > " + IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
                    return string;
                }
            }));
        }

        @Get(value="/uri%20with%20space")
        HttpResponse<String> uriWithSpace() {
            return HttpResponse.ok((Object)"Hello World");
        }

        @Get(value="/large")
        HttpResponse<String> large() {
            return HttpResponse.ok((Object)LARGE_BODY);
        }
    }
}

