/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.http;

import io.kestra.core.junit.annotations.KestraTest;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.repositories.LocalFlowRepositoryLoader;
import io.kestra.core.runners.TestMethodScopedWorker;
import io.kestra.core.runners.Worker;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.TestsUtils;
import io.kestra.jdbc.runner.JdbcScheduler;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;

@KestraTest(rebuildContext=true)
class TriggerTest {
    @Inject
    private ApplicationContext applicationContext;
    @Inject
    private FlowListenersInterface flowListenersService;
    @Inject
    @Named(value="executionQueue")
    private QueueInterface<Execution> executionQueue;
    @Inject
    private LocalFlowRepositoryLoader repositoryLoader;

    TriggerTest() {
    }

    @Test
    void trigger() throws Exception {
        CountDownLatch queueCount = new CountDownLatch(1);
        try (JdbcScheduler scheduler = new JdbcScheduler(this.applicationContext, this.flowListenersService);
             Worker worker = (Worker)this.applicationContext.createBean(TestMethodScopedWorker.class, new Object[]{IdUtils.create(), 8, null});){
            Flux receive = TestsUtils.receive(this.executionQueue, execution -> {
                if (((Execution)execution.getLeft()).getFlowId().equals("http-listen")) {
                    queueCount.countDown();
                }
            });
            worker.run();
            scheduler.run();
            this.repositoryLoader.load(Objects.requireNonNull(TriggerTest.class.getClassLoader().getResource("flows/valids/http-listen.yaml")));
            Assertions.assertTrue((boolean)queueCount.await(1L, TimeUnit.MINUTES));
            receive.blockLast();
        }
    }

    @Test
    void trigger_EncryptedBody() throws Exception {
        CountDownLatch queueCount = new CountDownLatch(1);
        try (JdbcScheduler scheduler = new JdbcScheduler(this.applicationContext, this.flowListenersService);
             Worker worker = (Worker)this.applicationContext.createBean(TestMethodScopedWorker.class, new Object[]{IdUtils.create(), 8, null});){
            Flux receive = TestsUtils.receive(this.executionQueue, execution -> {
                if (((Execution)execution.getLeft()).getFlowId().equals("http-listen-encrypted")) {
                    queueCount.countDown();
                }
            });
            worker.run();
            scheduler.run();
            this.repositoryLoader.load(Objects.requireNonNull(TriggerTest.class.getClassLoader().getResource("flows/valids/http-listen-encrypted.yaml")));
            Assertions.assertTrue((boolean)queueCount.await(1L, TimeUnit.MINUTES));
            receive.blockLast();
        }
    }
}

